/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.BufferPool;
import com.timgroup.statsd.Event;
import com.timgroup.statsd.Message;
import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.ServiceCheck;
import com.timgroup.statsd.StatsDBlockingProcessor;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import com.timgroup.statsd.StatsDNonBlockingProcessor;
import com.timgroup.statsd.StatsDProcessor;
import com.timgroup.statsd.StatsDSender;
import com.timgroup.statsd.Telemetry;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import jnr.unixsocket.UnixDatagramChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketOptions;

public class NonBlockingStatsDClient
implements StatsDClient {
    static final String DD_DOGSTATSD_PORT_ENV_VAR = "DD_DOGSTATSD_PORT";
    static final String DD_AGENT_HOST_ENV_VAR = "DD_AGENT_HOST";
    static final String DD_ENTITY_ID_ENV_VAR = "DD_ENTITY_ID";
    private static final String ENTITY_ID_TAG_NAME = "dd.internal.entity_id";
    public static final int DEFAULT_MAX_PACKET_SIZE_BYTES = 1400;
    public static final int DEFAULT_QUEUE_SIZE = 4096;
    public static final int DEFAULT_POOL_SIZE = 512;
    public static final int DEFAULT_PROCESSOR_WORKERS = 1;
    public static final int DEFAULT_SENDER_WORKERS = 1;
    public static final int DEFAULT_DOGSTATSD_PORT = 8125;
    public static final int SOCKET_TIMEOUT_MS = 100;
    public static final int SOCKET_BUFFER_BYTES = -1;
    public static final boolean DEFAULT_ENABLE_TELEMETRY = true;
    public static final String CLIENT_TAG = "client:java";
    public static final String CLIENT_VERSION_TAG = "client_version:";
    public static final String CLIENT_TRANSPORT_TAG = "client_transport:";
    private static final StatsDClientErrorHandler NO_OP_HANDLER = new StatsDClientErrorHandler(){

        @Override
        public void handle(Exception ex) {
        }
    };
    private static final ThreadLocal<NumberFormat> NUMBER_FORMATTER = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NonBlockingStatsDClient.newFormatter(false);
        }
    };
    private static final ThreadLocal<NumberFormat> SAMPLE_RATE_FORMATTER = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NonBlockingStatsDClient.newFormatter(true);
        }
    };
    private final String prefix;
    private final DatagramChannel clientChannel;
    private final StatsDClientErrorHandler handler;
    private final String constantTagsRendered;
    private final ExecutorService executor = Executors.newFixedThreadPool(4, new ThreadFactory(){
        final ThreadFactory delegate = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = this.delegate.newThread(runnable);
            result.setName("StatsD-" + result.getName());
            result.setDaemon(true);
            return result;
        }
    });
    protected final StatsDProcessor statsDProcessor;
    protected StatsDProcessor telemetryStatsDProcessor;
    protected final StatsDSender statsDSender;
    protected StatsDSender telemetryStatsDSender;
    protected final Telemetry telemetry;

    private static NumberFormat newFormatter(boolean sampler) {
        NumberFormat numberFormatter = NumberFormat.getInstance(Locale.US);
        numberFormatter.setGroupingUsed(false);
        if (numberFormatter instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormatter;
            DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
            symbols.setNaN("NaN");
            decimalFormat.setDecimalFormatSymbols(symbols);
        }
        if (sampler) {
            numberFormatter.setMinimumFractionDigits(6);
        } else {
            numberFormatter.setMaximumFractionDigits(6);
        }
        return numberFormatter;
    }

    private static String format(ThreadLocal<NumberFormat> formatter, double value) {
        return formatter.get().format(value);
    }

    /*
     * WARNING - void declaration
     */
    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, Callable<SocketAddress> telemetryAddressLookup, int timeout, int bufferSize, int maxPacketSizeBytes, String entityID, int poolSize, int processorWorkers, int senderWorkers, boolean blocking, boolean enableTelemetry, int telemetryFlushInterval) throws StatsDClientException {
        this.prefix = prefix != null && !prefix.isEmpty() ? prefix + "." : "";
        this.handler = errorHandler == null ? NO_OP_HANDLER : errorHandler;
        ArrayList<String> costantPreTags = new ArrayList<String>();
        if (constantTags != null) {
            for (String string : constantTags) {
                costantPreTags.add(string);
            }
        }
        NonBlockingStatsDClient.updateTagsWithEntityID(costantPreTags, entityID);
        for (Literal literal : Literal.values()) {
            String envVal = literal.envVal();
            if (envVal == null || envVal.trim().isEmpty()) continue;
            costantPreTags.add(literal.tag() + ":" + envVal);
        }
        this.constantTagsRendered = costantPreTags.isEmpty() ? null : NonBlockingStatsDClient.tagString(costantPreTags.toArray(new String[costantPreTags.size()]), null, new StringBuilder()).toString();
        costantPreTags = null;
        String transportType = "";
        try {
            SocketAddress socketAddress = addressLookup.call();
            if (socketAddress instanceof UnixSocketAddress) {
                this.clientChannel = UnixDatagramChannel.open();
                if (timeout > 0) {
                    this.clientChannel.setOption(UnixSocketOptions.SO_SNDTIMEO, (Object)timeout);
                }
                if (bufferSize > 0) {
                    this.clientChannel.setOption(UnixSocketOptions.SO_SNDBUF, (Object)bufferSize);
                }
                transportType = "uds";
            } else {
                this.clientChannel = DatagramChannel.open();
                transportType = "udp";
            }
            this.telemetryStatsDProcessor = this.statsDProcessor = this.createProcessor(queueSize, this.handler, maxPacketSizeBytes, poolSize, processorWorkers, blocking);
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("version.properties"));
            String telemetrytags = this.tagString(new String[]{CLIENT_TRANSPORT_TAG + transportType, CLIENT_VERSION_TAG + properties.getProperty("dogstatsd_client_version"), CLIENT_TAG}, new StringBuilder()).toString();
            DatagramChannel datagramChannel = this.clientChannel;
            if (addressLookup != telemetryAddressLookup) {
                SocketAddress telemetryAddress = telemetryAddressLookup.call();
                if (telemetryAddress instanceof UnixSocketAddress) {
                    UnixDatagramChannel unixDatagramChannel = UnixDatagramChannel.open();
                    if (timeout > 0) {
                        unixDatagramChannel.setOption(UnixSocketOptions.SO_SNDTIMEO, (Object)timeout);
                    }
                    if (bufferSize > 0) {
                        unixDatagramChannel.setOption(UnixSocketOptions.SO_SNDBUF, (Object)bufferSize);
                    }
                } else if (transportType == "uds") {
                    DatagramChannel datagramChannel2 = DatagramChannel.open();
                }
                this.telemetryStatsDProcessor = this.createProcessor(queueSize, this.handler, maxPacketSizeBytes, poolSize, 1, false);
            }
            this.telemetry = new Telemetry(telemetrytags, this.telemetryStatsDProcessor);
            this.telemetryStatsDSender = this.statsDSender = this.createSender(addressLookup, this.handler, this.clientChannel, this.statsDProcessor.getBufferPool(), this.statsDProcessor.getOutboundQueue(), senderWorkers, this.telemetry);
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                void var21_32;
                this.telemetryStatsDSender = this.createSender(telemetryAddressLookup, this.handler, (DatagramChannel)var21_32, this.telemetryStatsDProcessor.getBufferPool(), this.telemetryStatsDProcessor.getOutboundQueue(), 1, this.telemetry);
            }
        }
        catch (Exception exception) {
            throw new StatsDClientException("Failed to start StatsD client", exception);
        }
        this.executor.submit(this.statsDProcessor);
        this.executor.submit(this.statsDSender);
        if (enableTelemetry) {
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.executor.submit(this.telemetryStatsDProcessor);
                this.executor.submit(this.telemetryStatsDSender);
            }
            this.telemetry.start(telemetryFlushInterval);
        }
    }

    private NonBlockingStatsDClient(NonBlockingStatsDClient client) throws StatsDClientException {
        this.prefix = client.prefix;
        this.handler = client.handler;
        this.constantTagsRendered = client.constantTagsRendered;
        this.clientChannel = client.clientChannel;
        try {
            this.statsDProcessor = this.createProcessor(client.statsDProcessor);
            this.statsDSender = new StatsDSender(client.statsDSender, this.statsDProcessor.getBufferPool(), this.statsDProcessor.getOutboundQueue());
        }
        catch (Exception e) {
            throw new StatsDClientException("Failed to instantiate StatsD client copy", e);
        }
        this.telemetry = new Telemetry(client.telemetry.getTags(), this.statsDProcessor);
        this.executor.submit(this.statsDProcessor);
        this.executor.submit(this.statsDSender);
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, String ... constantTags) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).constantTags(constantTags).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, String[] constantTags, int maxPacketSizeBytes) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).constantTags(constantTags).maxPacketSizeBytes(maxPacketSizeBytes).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String ... constantTags) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).constantTags(constantTags).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, String[] constantTags, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).constantTags(constantTags).errorHandler(errorHandler).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, String entityID) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).entityID(entityID).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, int maxPacketSizeBytes) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).maxPacketSizeBytes(maxPacketSizeBytes).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, int timeout, int bufferSize, String[] constantTags, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).hostname(hostname).port(port).queueSize(queueSize).timeout(timeout).socketBufferSize(bufferSize).constantTags(constantTags).errorHandler(errorHandler).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).addressLookup(addressLookup).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, int timeout, int bufferSize) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).addressLookup(addressLookup).timeout(timeout).socketBufferSize(bufferSize).build());
    }

    @Deprecated
    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, int timeout, int bufferSize, int maxPacketSizeBytes) throws StatsDClientException {
        this(new NonBlockingStatsDClientBuilder().prefix(prefix).queueSize(queueSize).constantTags(constantTags).errorHandler(errorHandler).addressLookup(addressLookup).timeout(timeout).socketBufferSize(bufferSize).maxPacketSizeBytes(maxPacketSizeBytes).build());
    }

    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, int timeout, int bufferSize, int maxPacketSizeBytes, String entityID, int poolSize, int processorWorkers, int senderWorkers, boolean blocking, boolean enableTelemetry, int telemetryFlushInterval) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, addressLookup, addressLookup, timeout, bufferSize, maxPacketSizeBytes, entityID, poolSize, processorWorkers, senderWorkers, blocking, enableTelemetry, telemetryFlushInterval);
    }

    protected StatsDProcessor createProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int bufferPoolSize, int workers, boolean blocking) throws Exception {
        if (blocking) {
            return new StatsDBlockingProcessor(queueSize, handler, maxPacketSizeBytes, bufferPoolSize, workers);
        }
        return new StatsDNonBlockingProcessor(queueSize, handler, maxPacketSizeBytes, bufferPoolSize, workers);
    }

    protected StatsDProcessor createProcessor(StatsDProcessor processor) throws Exception {
        if (processor instanceof StatsDNonBlockingProcessor) {
            return new StatsDNonBlockingProcessor((StatsDNonBlockingProcessor)processor);
        }
        return new StatsDBlockingProcessor((StatsDBlockingProcessor)processor);
    }

    protected StatsDSender createSender(Callable<SocketAddress> addressLookup, StatsDClientErrorHandler handler, DatagramChannel clientChannel, BufferPool pool, BlockingQueue<ByteBuffer> buffers, int senderWorkers, Telemetry telemetry) throws Exception {
        return new StatsDSender(addressLookup, clientChannel, handler, pool, buffers, senderWorkers, telemetry);
    }

    @Override
    public void stop() {
        try {
            this.telemetry.stop();
            this.statsDProcessor.shutdown();
            this.statsDSender.shutdown();
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDProcessor.shutdown();
                this.telemetryStatsDSender.shutdown();
            }
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(30L, TimeUnit.SECONDS);
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
            }
            catch (Exception e) {
                this.handler.handle(e);
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
            }
        }
        catch (Exception e) {
            this.handler.handle(e);
        }
        finally {
            if (this.clientChannel != null) {
                try {
                    this.clientChannel.close();
                }
                catch (IOException e) {
                    this.handler.handle(e);
                }
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    static StringBuilder tagString(String[] tags, String tagPrefix, StringBuilder sb) {
        if (tagPrefix != null) {
            sb.append(tagPrefix);
            if (tags == null || tags.length == 0) {
                return sb;
            }
            sb.append(',');
        } else {
            if (tags == null || tags.length == 0) {
                return sb;
            }
            sb.append("|#");
        }
        for (int n = tags.length - 1; n >= 0; --n) {
            sb.append(tags[n]);
            if (n <= 0) continue;
            sb.append(',');
        }
        return sb;
    }

    StringBuilder tagString(String[] tags, StringBuilder builder) {
        return NonBlockingStatsDClient.tagString(tags, this.constantTagsRendered, builder);
    }

    private void sendMetric(Message message) {
        this.send(message);
        this.telemetry.incrMetricsSent(1);
    }

    private void send(Message message) {
        if (!this.statsDProcessor.send(message)) {
            this.telemetry.incrPacketDroppedQueue(1);
        }
    }

    private void send(String aspect, final double value, String type, double sampleRate, String[] tags) {
        if (Double.isNaN(sampleRate) || !this.isInvalidSample(sampleRate)) {
            this.sendMetric(new StatsDMessage(aspect, type, sampleRate, tags){

                @Override
                protected void writeValue(StringBuilder builder) {
                    builder.append(NonBlockingStatsDClient.format(NUMBER_FORMATTER, value));
                }
            });
        }
    }

    private void send(String aspect, double value, String type, String[] tags) {
        this.send(aspect, value, type, Double.NaN, tags);
    }

    private void send(String aspect, final long value, String type, double sampleRate, String[] tags) {
        if (Double.isNaN(sampleRate) || !this.isInvalidSample(sampleRate)) {
            this.sendMetric(new StatsDMessage(aspect, type, sampleRate, tags){

                @Override
                protected void writeValue(StringBuilder builder) {
                    builder.append(value);
                }
            });
        }
    }

    private void send(String aspect, long value, String type, String[] tags) {
        this.send(aspect, value, type, Double.NaN, tags);
    }

    @Override
    public void count(String aspect, long delta, String ... tags) {
        this.send(aspect, delta, "c", tags);
    }

    @Override
    public void count(String aspect, long delta, double sampleRate, String ... tags) {
        this.send(aspect, delta, "c", sampleRate, tags);
    }

    @Override
    public void count(String aspect, double delta, String ... tags) {
        this.send(aspect, delta, "c", tags);
    }

    @Override
    public void count(String aspect, double delta, double sampleRate, String ... tags) {
        this.send(aspect, delta, "c", sampleRate, tags);
    }

    @Override
    public void incrementCounter(String aspect, String ... tags) {
        this.count(aspect, 1L, tags);
    }

    @Override
    public void incrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, 1L, sampleRate, tags);
    }

    @Override
    public void increment(String aspect, String ... tags) {
        this.incrementCounter(aspect, tags);
    }

    @Override
    public void increment(String aspect, double sampleRate, String ... tags) {
        this.incrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void decrementCounter(String aspect, String ... tags) {
        this.count(aspect, -1L, tags);
    }

    @Override
    public void decrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, -1L, sampleRate, tags);
    }

    @Override
    public void decrement(String aspect, String ... tags) {
        this.decrementCounter(aspect, tags);
    }

    @Override
    public void decrement(String aspect, double sampleRate, String ... tags) {
        this.decrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, "g", tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, "g", sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, "g", tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, "g", sampleRate, tags);
    }

    @Override
    public void gauge(String aspect, double value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, double value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void gauge(String aspect, long value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, long value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, String ... tags) {
        this.send(aspect, timeInMs, "ms", tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, double sampleRate, String ... tags) {
        this.send(aspect, timeInMs, "ms", sampleRate, tags);
    }

    @Override
    public void time(String aspect, long value, String ... tags) {
        this.recordExecutionTime(aspect, value, tags);
    }

    @Override
    public void time(String aspect, long value, double sampleRate, String ... tags) {
        this.recordExecutionTime(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, "h", tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, "h", sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, "h", tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, "h", sampleRate, tags);
    }

    @Override
    public void histogram(String aspect, double value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, double value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void histogram(String aspect, long value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, long value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, "d", tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, "d", sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, "d", tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, "d", sampleRate, tags);
    }

    @Override
    public void distribution(String aspect, double value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, double value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void distribution(String aspect, long value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, long value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    private StringBuilder eventMap(Event event, StringBuilder res) {
        String sourceTypeName;
        String alertType;
        String priority;
        String aggregationKey;
        String hostname;
        long millisSinceEpoch = event.getMillisSinceEpoch();
        if (millisSinceEpoch != -1L) {
            res.append("|d:").append(millisSinceEpoch / 1000L);
        }
        if ((hostname = event.getHostname()) != null) {
            res.append("|h:").append(hostname);
        }
        if ((aggregationKey = event.getAggregationKey()) != null) {
            res.append("|k:").append(aggregationKey);
        }
        if ((priority = event.getPriority()) != null) {
            res.append("|p:").append(priority);
        }
        if ((alertType = event.getAlertType()) != null) {
            res.append("|t:").append(alertType);
        }
        if ((sourceTypeName = event.getSourceTypeName()) != null) {
            res.append("|s:").append(sourceTypeName);
        }
        return res;
    }

    @Override
    public void recordEvent(final Event event, final String ... tags) {
        this.statsDProcessor.send(new Message(){

            @Override
            public void writeTo(StringBuilder builder) {
                String title = NonBlockingStatsDClient.escapeEventString(NonBlockingStatsDClient.this.prefix + event.getTitle());
                String text = NonBlockingStatsDClient.escapeEventString(event.getText());
                builder.append("_e{").append(title.length()).append(",").append(text.length()).append("}:").append(title).append("|").append(text);
                NonBlockingStatsDClient.this.eventMap(event, builder);
                NonBlockingStatsDClient.this.tagString(tags, builder);
            }
        });
        this.telemetry.incrEventsSent(1);
    }

    private static String escapeEventString(String title) {
        return title.replace("\n", "\\n");
    }

    @Override
    public void recordServiceCheckRun(final ServiceCheck sc) {
        this.statsDProcessor.send(new Message(){

            @Override
            public void writeTo(StringBuilder sb) {
                sb.append("_sc|").append(sc.getName()).append("|").append(sc.getStatus());
                if (sc.getTimestamp() > 0) {
                    sb.append("|d:").append(sc.getTimestamp());
                }
                if (sc.getHostname() != null) {
                    sb.append("|h:").append(sc.getHostname());
                }
                NonBlockingStatsDClient.this.tagString(sc.getTags(), sb);
                if (sc.getMessage() != null) {
                    sb.append("|m:").append(sc.getEscapedMessage());
                }
            }
        });
        this.telemetry.incrServiceChecksSent(1);
    }

    private static boolean updateTagsWithEntityID(List<String> tags, String entityID) {
        if (entityID == null || entityID.trim().isEmpty()) {
            entityID = System.getenv(DD_ENTITY_ID_ENV_VAR);
        }
        if (entityID != null && !entityID.trim().isEmpty()) {
            String entityTag = "dd.internal.entity_id:" + entityID;
            return tags.add(entityTag);
        }
        return false;
    }

    @Override
    public void serviceCheck(ServiceCheck sc) {
        this.recordServiceCheckRun(sc);
    }

    @Override
    public void recordSetValue(String aspect, final String value, String ... tags) {
        this.statsDProcessor.send(new StatsDMessage(aspect, "s", Double.NaN, tags){

            @Override
            protected void writeValue(StringBuilder builder) {
                builder.append(value);
            }
        });
    }

    private boolean isInvalidSample(double sampleRate) {
        return sampleRate != 1.0 && ThreadLocalRandom.current().nextDouble() > sampleRate;
    }

    abstract class StatsDMessage
    implements Message {
        final String aspect;
        final String type;
        final double sampleRate;
        final String[] tags;

        protected StatsDMessage(String aspect, String type, double sampleRate, String[] tags) {
            this.aspect = aspect;
            this.type = type;
            this.sampleRate = sampleRate;
            this.tags = tags;
        }

        @Override
        public final void writeTo(StringBuilder builder) {
            builder.append(NonBlockingStatsDClient.this.prefix).append(this.aspect).append(':');
            this.writeValue(builder);
            builder.append('|').append(this.type);
            if (!Double.isNaN(this.sampleRate)) {
                builder.append('|').append('@').append(NonBlockingStatsDClient.format(SAMPLE_RATE_FORMATTER, this.sampleRate));
            }
            NonBlockingStatsDClient.this.tagString(this.tags, builder);
        }

        protected abstract void writeValue(StringBuilder var1);
    }

    static enum Literal {
        SERVICE,
        ENV,
        VERSION;

        private static final String PREFIX = "dd";

        String envName() {
            return ("dd_" + this.toString()).toUpperCase();
        }

        String envVal() {
            return System.getenv(this.envName());
        }

        String tag() {
            return this.toString().toLowerCase();
        }
    }
}

