/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.TracePropagationStyle;
import ddtrot.dd.context.propagation.CarrierSetter;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.propagation.ContextInterpreter;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.TagContextExtractor;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoneCodec {
    private static final Logger log = LoggerFactory.getLogger(NoneCodec.class);
    public static final HttpCodec.Injector INJECTOR = new HttpCodec.Injector(){

        @Override
        public <C> void inject(DDSpanContext context, C carrier, CarrierSetter<C> setter) {
        }
    };

    public static HttpCodec.Extractor newExtractor(Config config, Supplier<TraceConfig> traceConfigSupplier) {
        return new TagContextExtractor(traceConfigSupplier, () -> new NoneContextInterpreter(config));
    }

    private static class NoneContextInterpreter
    extends ContextInterpreter {
        private NoneContextInterpreter(Config config) {
            super(config);
        }

        @Override
        public TracePropagationStyle style() {
            return TracePropagationStyle.NONE;
        }

        @Override
        public boolean accept(String key, String value) {
            if (null == key || key.isEmpty()) {
                return true;
            }
            if (LOG_EXTRACT_HEADER_NAMES) {
                log.debug("Header: {}", (Object)key);
            }
            char first = Character.toLowerCase(key.charAt(0));
            switch (first) {
                case 'x': {
                    if (!this.handledXForwarding(key, value)) break;
                    return true;
                }
                case 'f': {
                    if (!this.handledForwarding(key, value)) break;
                    return true;
                }
                case 'u': {
                    if (!this.handledUserAgent(key, value)) break;
                    return true;
                }
            }
            if (this.handledIpHeaders(key, value)) {
                return true;
            }
            if (this.handleTags(key, value)) {
                return true;
            }
            this.handleMappedBaggage(key, value);
            return true;
        }
    }
}

