/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import ddtrot.dd.trace.api.datastreams.DataStreamsTags;
import ddtrot.dd.trace.core.histogram.Histogram;
import ddtrot.dd.trace.core.histogram.Histograms;

public class StatsGroup {
    private static final double NANOSECONDS_TO_SECOND = 1.0E9;
    private final DataStreamsTags tags;
    private final long hash;
    private final long parentHash;
    private final Histogram pathwayLatency;
    private final Histogram edgeLatency;
    private final Histogram payloadSize;

    public StatsGroup(DataStreamsTags tags, long hash, long parentHash) {
        this.tags = tags;
        this.hash = hash;
        this.parentHash = parentHash;
        this.pathwayLatency = Histograms.newLogHistogram();
        this.edgeLatency = Histograms.newLogHistogram();
        this.payloadSize = Histograms.newLogHistogram();
    }

    public void add(long pathwayLatencyNano, long edgeLatencyNano, long payloadSizeBytes) {
        this.pathwayLatency.accept((double)pathwayLatencyNano / 1.0E9);
        this.edgeLatency.accept((double)edgeLatencyNano / 1.0E9);
        if (payloadSizeBytes != 0L) {
            this.payloadSize.accept(payloadSizeBytes);
        }
    }

    public DataStreamsTags getTags() {
        return this.tags;
    }

    public long getHash() {
        return this.hash;
    }

    public long getParentHash() {
        return this.parentHash;
    }

    public Histogram getPathwayLatency() {
        return this.pathwayLatency;
    }

    public Histogram getEdgeLatency() {
        return this.edgeLatency;
    }

    public Histogram getPayloadSize() {
        return this.payloadSize;
    }

    public String toString() {
        return "StatsGroup{tags='" + this.tags + '\'' + ", hash=" + this.hash + ", parentHash=" + this.parentHash + '}';
    }
}

