/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import ddtrot.com.squareup.moshi.Json;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.bootstrap.instrumentation.api.Schema;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SchemaIterator;
import ddtrot.dd.trace.util.FNV64Hash;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SchemaBuilder
implements ddtrot.dd.trace.bootstrap.instrumentation.api.SchemaBuilder {
    private final OpenApiSchema schema = new OpenApiSchema();
    private static final DDCache<String, Schema> CACHE = DDCaches.newFixedSizeCache(32);
    private static final int maxDepth = 10;
    private static final int maxProperties = 1000;
    private static final long HASH_INIT = FNV64Hash.generateHash(new byte[0], FNV64Hash.Version.v1A);
    private long currentHash = HASH_INIT;
    private int properties;
    private final SchemaIterator iterator;

    public SchemaBuilder(SchemaIterator iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean addProperty(String schemaName, String fieldName, boolean isArray, String type, String description, String ref, String format, List<String> enumValues, Map<String, String> extensions) {
        if (this.properties >= 1000) {
            return false;
        }
        ++this.properties;
        OpenApiSchema.Property property = new OpenApiSchema.Property(type, description, ref, format, enumValues, isArray ? null : extensions, null);
        if (isArray) {
            property = new OpenApiSchema.Property("array", null, null, null, null, extensions, property);
        }
        this.schema.components.schemas.get((Object)schemaName).properties.put(fieldName, property);
        return true;
    }

    @Override
    public void addToHash(int value) {
        this.addToHash(Integer.toString(value));
    }

    @Override
    public void addToHash(String value) {
        this.currentHash = FNV64Hash.continueHash(this.currentHash, value, FNV64Hash.Version.v1A);
    }

    public Schema build() {
        this.iterator.iterateOverSchema(this);
        Moshi moshi = new Moshi.Builder().build();
        JsonAdapter<OpenApiSchema> jsonAdapter = moshi.adapter(OpenApiSchema.class);
        String definition = jsonAdapter.toJson(this.schema);
        if (this.currentHash == HASH_INIT) {
            this.currentHash = FNV64Hash.generateHash(definition, FNV64Hash.Version.v1A);
        }
        return new Schema(definition, Long.toUnsignedString(this.currentHash));
    }

    @Override
    public boolean shouldExtractSchema(String schemaName, int depth) {
        if (depth > 10) {
            return false;
        }
        if (this.schema.components.schemas.containsKey(schemaName)) {
            return false;
        }
        this.schema.components.schemas.put(schemaName, new OpenApiSchema.Schema());
        return true;
    }

    public static Schema getSchema(String schemaName, SchemaIterator iterator) {
        return CACHE.computeIfAbsent(schemaName, s -> new SchemaBuilder(iterator).build());
    }

    public static class OpenApiSchema {
        public String openapi = "3.0.0";
        public final Components components = new Components();

        public static class Property {
            public String type;
            public String description;
            @Json(name="$ref")
            public String ref;
            public String format;
            @Json(name="enum")
            public List<String> enumValues;
            public final Map<String, String> extensions;
            public Property items;

            public Property(String type, String description, String ref, String format, List<String> enumValues, Map<String, String> extensions, Property items) {
                this.type = type;
                this.description = description;
                this.ref = ref;
                this.format = format;
                this.enumValues = enumValues;
                this.extensions = extensions;
                this.items = items;
            }
        }

        public static class Schema {
            public String type = "object";
            public final Map<String, Property> properties = new LinkedHashMap<String, Property>();
        }

        public static class Components {
            public final Map<String, Schema> schemas = new LinkedHashMap<String, Schema>();
        }
    }
}

