/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.DDTraceId;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.core.CoreTracer;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.TraceCollector;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;

public class StreamingTraceCollector
extends TraceCollector {
    private final HealthMetrics healthMetrics;
    private volatile DDSpan rootSpan;
    private static final AtomicReferenceFieldUpdater<StreamingTraceCollector, DDSpan> ROOT_SPAN = AtomicReferenceFieldUpdater.newUpdater(StreamingTraceCollector.class, DDSpan.class, "rootSpan");

    private StreamingTraceCollector(CoreTracer tracer, CoreTracer.ConfigSnapshot traceConfig, TimeSource timeSource, HealthMetrics healthMetrics) {
        super(tracer, traceConfig != null ? traceConfig : tracer.captureTraceConfig(), timeSource);
        this.healthMetrics = healthMetrics;
    }

    @Override
    void touch() {
    }

    @Override
    void registerSpan(DDSpan span) {
        ROOT_SPAN.compareAndSet(this, null, span);
        this.healthMetrics.onCreateSpan();
    }

    @Override
    DDSpan getRootSpan() {
        return this.rootSpan;
    }

    @Override
    TraceCollector.PublishState onPublish(DDSpan span) {
        DDSpan rootSpan = this.getRootSpan();
        if (span == rootSpan) {
            this.tracer.onRootSpanPublished(rootSpan);
        }
        this.healthMetrics.onFinishSpan();
        this.tracer.write(Collections.singletonList(span));
        return TraceCollector.PublishState.WRITTEN;
    }

    @Override
    public void registerContinuation(AgentScope.Continuation continuation) {
    }

    @Override
    public void removeContinuation(AgentScope.Continuation continuation) {
    }

    static class Factory
    implements TraceCollector.Factory {
        private final CoreTracer tracer;
        private final TimeSource timeSource;
        private final HealthMetrics healthMetrics;

        Factory(CoreTracer tracer, TimeSource timeSource, HealthMetrics healthMetrics) {
            this.tracer = tracer;
            this.timeSource = timeSource;
            this.healthMetrics = healthMetrics;
        }

        @Override
        public StreamingTraceCollector create(@Nonnull DDTraceId traceId) {
            return this.create(traceId, null);
        }

        @Override
        public StreamingTraceCollector create(@Nonnull DDTraceId traceId, CoreTracer.ConfigSnapshot traceConfig) {
            return new StreamingTraceCollector(this.tracer, traceConfig, this.timeSource, this.healthMetrics);
        }
    }
}

