/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.civisibility.interceptor;

import datadog.trace.api.Config;
import datadog.trace.api.interceptor.AbstractTraceInterceptor;
import datadog.trace.api.interceptor.MutableSpan;
import ddtrot.dd.trace.api.civisibility.CiVisibilityWellKnownTags;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class CiVisibilityApmProtocolInterceptor
extends AbstractTraceInterceptor {
    public static final CiVisibilityApmProtocolInterceptor INSTANCE = new CiVisibilityApmProtocolInterceptor(AbstractTraceInterceptor.Priority.CI_VISIBILITY_APM, Config.get());
    private final CiVisibilityWellKnownTags wellKnownTags;

    protected CiVisibilityApmProtocolInterceptor(AbstractTraceInterceptor.Priority priority, Config config) {
        super(priority);
        this.wellKnownTags = config.getCiVisibilityWellKnownTags();
    }

    public Collection<? extends MutableSpan> onTraceComplete(Collection<? extends MutableSpan> trace) {
        List filteredTrace = trace.stream().filter(this::isSupportedByApmProtocol).collect(Collectors.toList());
        for (MutableSpan span : filteredTrace) {
            span.setTag("test_session_id", (Number)null);
            span.setTag("test_module_id", (Number)null);
            span.setTag("test_suite_id", (Number)null);
            String spanType = span.getSpanType();
            if (!"test".equals(spanType)) continue;
            span.setTag("runtime.name", this.wellKnownTags.getRuntimeName().toString());
            span.setTag("runtime.vendor", this.wellKnownTags.getRuntimeVendor().toString());
            span.setTag("runtime.version", this.wellKnownTags.getRuntimeVersion().toString());
            span.setTag("os.architecture", this.wellKnownTags.getOsArch().toString());
            span.setTag("os.platform", this.wellKnownTags.getOsPlatform().toString());
            span.setTag("os.version", this.wellKnownTags.getOsVersion().toString());
            span.setTag("_dd.test.is_user_provided_service", this.wellKnownTags.getIsUserProvidedService().toString());
        }
        return filteredTrace;
    }

    private boolean isSupportedByApmProtocol(MutableSpan span) {
        String spanType = span.getSpanType();
        return !"test_session_end".equals(spanType) && !"test_module_end".equals(spanType) && !"test_suite_end".equals(spanType);
    }
}

