/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.telemetry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LogCollector {
    public static final Marker SEND_TELEMETRY = MarkerFactory.getMarker((String)"SEND_TELEMETRY");
    public static final Marker EXCLUDE_TELEMETRY = MarkerFactory.getMarker((String)"EXCLUDE_TELEMETRY");
    private static final int DEFAULT_MAX_CAPACITY = 10;
    private static final LogCollector INSTANCE = new LogCollector();
    private final Map<RawLogMessage, AtomicInteger> rawLogMessages;
    private final int maxCapacity;

    public static LogCollector get() {
        return INSTANCE;
    }

    private LogCollector() {
        this(10);
    }

    LogCollector(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.rawLogMessages = new ConcurrentHashMap<RawLogMessage, AtomicInteger>(maxCapacity);
    }

    public void addLogMessage(String logLevel, String message, @Nullable Throwable throwable) {
        this.addLogMessage(logLevel, message, throwable, null);
    }

    public void addLogMessage(String logLevel, String message, @Nullable Throwable throwable, @Nullable String tags) {
        if (this.rawLogMessages.size() >= this.maxCapacity) {
            return;
        }
        RawLogMessage rawLogMessage = new RawLogMessage(logLevel, message, throwable, tags, System.currentTimeMillis() / 1000L);
        AtomicInteger count = this.rawLogMessages.computeIfAbsent(rawLogMessage, k -> new AtomicInteger());
        count.incrementAndGet();
    }

    public Collection<RawLogMessage> drain() {
        if (this.rawLogMessages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RawLogMessage> list = new ArrayList<RawLogMessage>();
        Iterator<Map.Entry<RawLogMessage, AtomicInteger>> iterator = this.rawLogMessages.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<RawLogMessage, AtomicInteger> entry = iterator.next();
            RawLogMessage logMessage = entry.getKey();
            logMessage.count = entry.getValue().get();
            iterator.remove();
            list.add(logMessage);
        }
        return list;
    }

    public static class RawLogMessage {
        public final String message;
        public final String logLevel;
        public final Throwable throwable;
        public final String tags;
        public final long timestamp;
        public int count;

        public RawLogMessage(String logLevel, String message, Throwable throwable, String tags, long timestamp) {
            this.logLevel = logLevel;
            this.message = message;
            this.throwable = throwable;
            this.tags = tags;
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RawLogMessage that = (RawLogMessage)o;
            return Objects.equals(this.logLevel, that.logLevel) && Objects.equals(this.message, that.message) && Objects.equals(this.throwable == null ? null : this.throwable.getClass(), that.throwable == null ? null : that.throwable.getClass()) && Objects.deepEquals(this.throwable == null ? null : this.throwable.getStackTrace(), that.throwable == null ? null : that.throwable.getStackTrace());
        }

        public int hashCode() {
            return Objects.hash(this.logLevel, this.message, this.throwable == null ? null : this.throwable.getClass());
        }
    }
}

