/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.naming.v0;

import datadog.trace.api.ClassloaderConfigurationOverrides;
import datadog.trace.api.Config;
import ddtrot.dd.trace.api.naming.NamingSchema;
import ddtrot.dd.trace.api.remoteconfig.ServiceNameCollector;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

class MessagingNamingV0
implements NamingSchema.ForMessaging {
    private static final Supplier<String> NULL_SUPPLIER = () -> null;
    private final boolean allowInferredServices;

    public MessagingNamingV0(boolean allowInferredServices) {
        this.allowInferredServices = allowInferredServices;
    }

    @Override
    @Nonnull
    public String outboundOperation(@Nonnull String messagingSystem) {
        if ("amqp".equals(messagingSystem)) {
            return "amqp.command";
        }
        return messagingSystem + ".produce";
    }

    @Override
    public Supplier<String> outboundService(@Nonnull String messagingSystem, boolean useLegacyTracing) {
        return this.inboundService(messagingSystem, useLegacyTracing);
    }

    @Override
    @Nonnull
    public String inboundOperation(@Nonnull String messagingSystem) {
        switch (messagingSystem) {
            case "amqp": {
                return "amqp.command";
            }
            case "sqs": {
                return "aws.http";
            }
        }
        return messagingSystem + ".consume";
    }

    @Override
    public Supplier<String> inboundService(@Nonnull String messagingSystem, boolean useLegacyTracing) {
        if (this.allowInferredServices) {
            if (useLegacyTracing) {
                ServiceNameCollector.get().addService(messagingSystem);
                return messagingSystem::toString;
            }
            if (Config.get().isJeeSplitByDeployment()) {
                return ClassloaderDependentNamingSupplier.INSTANCE;
            }
            return Config.get()::getServiceName;
        }
        return NULL_SUPPLIER;
    }

    @Override
    @Nonnull
    public Supplier<String> timeInQueueService(@Nonnull String messagingSystem) {
        ServiceNameCollector.get().addService(messagingSystem);
        return () -> messagingSystem;
    }

    @Override
    @Nonnull
    public String timeInQueueOperation(@Nonnull String messagingSystem) {
        if ("sqs".equals(messagingSystem)) {
            return "aws.http";
        }
        return messagingSystem + ".deliver";
    }

    private static class ClassloaderDependentNamingSupplier
    implements Supplier<String> {
        private static final ClassloaderDependentNamingSupplier INSTANCE = new ClassloaderDependentNamingSupplier();
        private final String configServiceName = Config.get().getServiceName();

        private ClassloaderDependentNamingSupplier() {
        }

        @Override
        public String get() {
            ClassloaderConfigurationOverrides.ContextualInfo contextual = ClassloaderConfigurationOverrides.maybeGetContextualInfo();
            if (contextual != null && contextual.getServiceName() != null) {
                String serviceName = contextual.getServiceName();
                ServiceNameCollector.get().addService(serviceName);
                return serviceName;
            }
            return this.configServiceName;
        }
    }
}

