/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast;

public class VulnerabilityMarks {
    public static final int NOT_MARKED = 0;
    public static final int XPATH_INJECTION_MARK = 1;
    public static final int SQL_INJECTION_MARK = 2;
    public static final int COMMAND_INJECTION_MARK = 4;
    public static final int PATH_TRAVERSAL_MARK = 8;
    public static final int LDAP_INJECTION_MARK = 16;
    public static final int SSRF_MARK = 32;
    public static final int UNVALIDATED_REDIRECT_MARK = 64;
    public static final int XSS_MARK = 128;
    public static final int TRUST_BOUNDARY_VIOLATION_MARK = 256;
    public static final int HEADER_INJECTION_MARK = 512;
    public static final int REFLECTION_INJECTION_MARK = 1024;
    public static final int UNTRUSTED_DESERIALIZATION_MARK = 2048;
    public static final int CUSTOM_SECURITY_CONTROL_MARK = 8192;
    public static final int EMAIL_HTML_INJECTION_MARK = 16384;
    public static final int HTML_ESCAPED_MARK = 16512;

    private VulnerabilityMarks() {
    }

    public static int markForAll() {
        return 28671;
    }

    public static int getMarkFromVulnerabitityType(String vulnerabilityTypeString) {
        switch (vulnerabilityTypeString) {
            case "XSS": {
                return 128;
            }
            case "XPATH_INJECTION": {
                return 1;
            }
            case "SQL_INJECTION": {
                return 2;
            }
            case "COMMAND_INJECTION": {
                return 4;
            }
            case "PATH_TRAVERSAL": {
                return 8;
            }
            case "LDAP_INJECTION": {
                return 16;
            }
            case "SSRF": {
                return 32;
            }
            case "UNVALIDATED_REDIRECT": {
                return 64;
            }
            case "TRUST_BOUNDARY_VIOLATION": {
                return 256;
            }
            case "HEADER_INJECTION": {
                return 512;
            }
            case "REFLECTION_INJECTION": {
                return 1024;
            }
            case "UNTRUSTED_DESERIALIZATION": {
                return 2048;
            }
            case "CUSTOM_SECURITY_CONTROL": {
                return 8192;
            }
            case "EMAIL_HTML_INJECTION": {
                return 16384;
            }
        }
        return 0;
    }
}

