/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.context;

import ddtrot.dd.context.ContextKey;
import ddtrot.dd.context.ContextProviders;
import ddtrot.dd.context.ContextScope;
import ddtrot.dd.context.EmptyContext;
import ddtrot.dd.context.ImplicitContextKeyed;
import javax.annotation.Nullable;

public interface Context {
    public static Context root() {
        return EmptyContext.INSTANCE;
    }

    public static Context current() {
        return ContextProviders.manager().current();
    }

    default public ContextScope attach() {
        return ContextProviders.manager().attach(this);
    }

    default public Context swap() {
        return ContextProviders.manager().swap(this);
    }

    public static Context from(Object carrier) {
        return ContextProviders.binder().from(carrier);
    }

    default public void attachTo(Object carrier) {
        ContextProviders.binder().attachTo(carrier, this);
    }

    public static Context detachFrom(Object carrier) {
        return ContextProviders.binder().detachFrom(carrier);
    }

    @Nullable
    public <T> T get(ContextKey<T> var1);

    public <T> Context with(ContextKey<T> var1, @Nullable T var2);

    default public <T, U> Context with(ContextKey<T> firstKey, @Nullable T firstValue, ContextKey<U> secondKey, @Nullable U secondValue) {
        return this.with(firstKey, firstValue).with(secondKey, secondValue);
    }

    default public Context with(@Nullable ImplicitContextKeyed value) {
        if (value == null) {
            return Context.root();
        }
        return value.storeInto(this);
    }
}

