/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.ddagent;

import datadog.trace.api.Config;
import ddtrot.dd.common.container.ContainerInfo;
import ddtrot.dd.common.socket.SocketUtils;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.TracerVersion;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.remoteconfig.ConfigurationPoller;
import ddtrot.dd.remoteconfig.DefaultConfigurationPoller;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCommunicationObjects {
    private static final Logger log = LoggerFactory.getLogger(SharedCommunicationObjects.class);
    private final List<Runnable> pausedComponents = new ArrayList<Runnable>();
    private volatile boolean paused;
    public OkHttpClient okHttpClient;
    public HttpUrl agentUrl;
    public Monitoring monitoring;
    private volatile DDAgentFeaturesDiscovery featuresDiscovery;
    private ConfigurationPoller configurationPoller;

    public SharedCommunicationObjects() {
        this(false);
    }

    public SharedCommunicationObjects(boolean paused) {
        this.paused = paused;
    }

    public void createRemaining(Config config) {
        if (this.monitoring == null) {
            this.monitoring = Monitoring.DISABLED;
        }
        if (this.agentUrl == null) {
            this.agentUrl = SharedCommunicationObjects.parseAgentUrl(config);
            if (this.agentUrl == null) {
                throw new IllegalArgumentException("Bad agent URL: " + config.getAgentUrl());
            }
        }
        if (this.okHttpClient == null) {
            String unixDomainSocket = SocketUtils.discoverApmSocket(config);
            String namedPipe = config.getAgentNamedPipe();
            this.okHttpClient = OkHttpUtils.buildHttpClient(this.agentUrl, unixDomainSocket, namedPipe, SharedCommunicationObjects.getHttpClientTimeout(config));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whenReady(Runnable callback) {
        if (this.paused) {
            List<Runnable> list = this.pausedComponents;
            synchronized (list) {
                if (this.paused) {
                    this.pausedComponents.add(callback);
                    return;
                }
            }
        }
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.paused = false;
        if (null != this.featuresDiscovery) {
            this.featuresDiscovery.discoverIfOutdated();
        } else {
            Security.getProviders();
        }
        List<Runnable> list = this.pausedComponents;
        synchronized (list) {
            for (Runnable callback : this.pausedComponents) {
                try {
                    callback.run();
                }
                catch (Throwable e) {
                    log.warn("Problem resuming remote component {}", (Object)callback, (Object)e);
                }
            }
            this.pausedComponents.clear();
        }
    }

    private static HttpUrl parseAgentUrl(Config config) {
        String agentUrl = config.getAgentUrl();
        if (agentUrl.startsWith("unix:")) {
            agentUrl = "http://" + config.getAgentHost() + ":" + config.getAgentPort();
        }
        return HttpUrl.parse(agentUrl);
    }

    private static long getHttpClientTimeout(Config config) {
        if (!config.isCiVisibilityEnabled()) {
            return TimeUnit.SECONDS.toMillis(config.getAgentTimeout());
        }
        return config.getCiVisibilityBackendApiTimeoutMillis();
    }

    public ConfigurationPoller configurationPoller(Config config) {
        if (this.configurationPoller == null && config.isRemoteConfigEnabled()) {
            this.configurationPoller = this.createPoller(config);
        }
        return this.configurationPoller;
    }

    private ConfigurationPoller createPoller(Config config) {
        Supplier<String> configUrlSupplier;
        String containerId = ContainerInfo.get().getContainerId();
        String entityId = ContainerInfo.getEntityId();
        String remoteConfigUrl = config.getFinalRemoteConfigUrl();
        if (remoteConfigUrl != null) {
            configUrlSupplier = new FixedConfigUrlSupplier(remoteConfigUrl);
        } else {
            this.createRemaining(config);
            configUrlSupplier = new RetryConfigUrlSupplier(this, config);
        }
        return new DefaultConfigurationPoller(config, TracerVersion.TRACER_VERSION, containerId, entityId, (Supplier)configUrlSupplier, this.okHttpClient);
    }

    public void setFeaturesDiscovery(DDAgentFeaturesDiscovery featuresDiscovery) {
        this.featuresDiscovery = featuresDiscovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDAgentFeaturesDiscovery featuresDiscovery(Config config) {
        DDAgentFeaturesDiscovery ret = this.featuresDiscovery;
        if (ret == null) {
            SharedCommunicationObjects sharedCommunicationObjects = this;
            synchronized (sharedCommunicationObjects) {
                ret = this.featuresDiscovery;
                if (ret == null) {
                    this.createRemaining(config);
                    ret = new DDAgentFeaturesDiscovery(this.okHttpClient, this.monitoring, this.agentUrl, config.isTraceAgentV05Enabled(), config.isTracerMetricsEnabled());
                    if (!this.paused) {
                        if (AgentThreadFactory.AGENT_THREAD_GROUP.equals(Thread.currentThread().getThreadGroup())) {
                            ret.discover();
                        } else {
                            AgentTaskScheduler.INSTANCE.execute(ret::discoverIfOutdated);
                        }
                    }
                    this.featuresDiscovery = ret;
                }
            }
        }
        return ret;
    }

    private static final class RetryConfigUrlSupplier
    implements Supplier<String> {
        private String configUrl;
        private final SharedCommunicationObjects sco;
        private final Config config;

        private RetryConfigUrlSupplier(SharedCommunicationObjects sco, Config config) {
            this.sco = sco;
            this.config = config;
        }

        @Override
        public String get() {
            if (this.configUrl != null) {
                return this.configUrl;
            }
            DDAgentFeaturesDiscovery discovery = this.sco.featuresDiscovery(this.config);
            discovery.discoverIfOutdated();
            String configEndpoint = discovery.getConfigEndpoint();
            if (configEndpoint == null) {
                return null;
            }
            this.configUrl = discovery.buildUrl(configEndpoint).toString();
            log.debug("Found remote config endpoint: {}", (Object)this.configUrl);
            return this.configUrl;
        }
    }

    private static final class FixedConfigUrlSupplier
    implements Supplier<String> {
        private final String configUrl;

        private FixedConfigUrlSupplier(String configUrl) {
            this.configUrl = configUrl;
        }

        @Override
        public String get() {
            return this.configUrl;
        }
    }
}

