/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.timgroup.statsd;

import ddtrot.com.timgroup.statsd.Message;

public abstract class NumericMessage<T extends Number>
extends Message {
    protected Number value;

    protected NumericMessage(Message.Type type) {
        super(type);
    }

    protected NumericMessage(String aspect, Message.Type type, T value, String[] tags) {
        super(aspect, type, tags);
        this.value = value;
    }

    @Override
    public void aggregate(Message message) {
        NumericMessage msg = (NumericMessage)message;
        Number value = msg.getValue();
        switch (msg.getType()) {
            case GAUGE: {
                this.setValue(value);
                break;
            }
            default: {
                if (value instanceof Double) {
                    this.setValue(this.getValue().doubleValue() + value.doubleValue());
                    break;
                }
                if (value instanceof Integer) {
                    this.setValue(this.getValue().intValue() + value.intValue());
                    break;
                }
                if (!(value instanceof Long)) break;
                this.setValue(this.getValue().longValue() + value.longValue());
            }
        }
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }
}

