/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.datadoghq.sketch.ddsketch;

import ddtrot.com.datadoghq.sketch.WithExactSummaryStatistics;
import ddtrot.com.datadoghq.sketch.ddsketch.DDSketch;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Flag;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Input;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Output;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.VarEncodingHelper;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.store.Store;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;

public class DDSketchWithExactSummaryStatistics
extends WithExactSummaryStatistics<DDSketch> {
    public DDSketchWithExactSummaryStatistics(Supplier<DDSketch> ddSketchConstructor) {
        super(ddSketchConstructor);
    }

    public DDSketchWithExactSummaryStatistics(IndexMapping indexMapping, Supplier<Store> storeSupplier) {
        this(() -> new DDSketch(indexMapping, storeSupplier));
    }

    private DDSketchWithExactSummaryStatistics(DDSketch sketch, double count, double sum, double sumCompensation, double simpleSum, double min, double max) {
        super(sketch, count, sum, sumCompensation, simpleSum, min, max);
    }

    public static DDSketchWithExactSummaryStatistics of(DDSketch sketch, double count, double min, double max, double sum) {
        if (!(count >= 0.0)) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        if (count > 0.0 && min > max) {
            throw new IllegalArgumentException("The minimum cannot be greater than the maximum.");
        }
        if (count == 0.0 && (min != Double.POSITIVE_INFINITY || max != Double.NEGATIVE_INFINITY)) {
            throw new IllegalArgumentException("The minimum and maximum of an empty sketch should respectively be POSITIVE_INFINITY and NEGATIVE_INFINITY.");
        }
        return new DDSketchWithExactSummaryStatistics(Objects.requireNonNull(sketch), count, sum, 0.0, sum, min, max);
    }

    public IndexMapping getIndexMapping() {
        return ((DDSketch)this.sketch()).getIndexMapping();
    }

    public Store getNegativeValueStore() {
        return ((DDSketch)this.sketch()).getNegativeValueStore();
    }

    public Store getPositiveValueStore() {
        return ((DDSketch)this.sketch()).getPositiveValueStore();
    }

    @Override
    public DDSketchWithExactSummaryStatistics copy() {
        return new DDSketchWithExactSummaryStatistics(((DDSketch)this.sketch()).copy(), this.getCount(), this.sum(), this.sumCompensation(), this.simpleSum(), this.min(), this.max());
    }

    public void encode(Output output, boolean omitIndexMapping) throws IOException {
        double sum;
        double count = this.getCount();
        if (count != 0.0) {
            Flag.COUNT.encode(output);
            VarEncodingHelper.encodeVarDouble(output, count);
            Flag.MIN.encode(output);
            output.writeDoubleLE(this.getMinValue());
            Flag.MAX.encode(output);
            output.writeDoubleLE(this.getMaxValue());
        }
        if ((sum = this.getSum()) != 0.0) {
            Flag.SUM.encode(output);
            output.writeDoubleLE(sum);
        }
        ((DDSketch)this.sketch()).encode(output, omitIndexMapping);
    }

    public void decodeAndMergeWith(Input input) throws IOException {
        ((DDSketch)this.sketch()).decodeAndMergeWith(input, this::decodeSummaryStatistic);
    }

    public static DDSketchWithExactSummaryStatistics decode(Input input, Supplier<Store> storeSupplier) throws IOException {
        return DDSketchWithExactSummaryStatistics.decode(input, storeSupplier, null);
    }

    public static DDSketchWithExactSummaryStatistics decode(Input input, Supplier<Store> storeSupplier, IndexMapping indexMapping) throws IOException {
        DecodingState state = new DecodingState();
        DDSketch sketch = DDSketch.decode(input, storeSupplier, indexMapping, (x$0, x$1) -> state.decodeSummaryStatistic(x$0, x$1));
        if (state.count == 0.0 && !sketch.isEmpty()) {
            throw new IllegalArgumentException("The exact summary statistics are missing.");
        }
        return new DDSketchWithExactSummaryStatistics(sketch, state.count, state.sum, 0.0, state.sum, state.min, state.max);
    }

    private void decodeSummaryStatistic(Input input, Flag flag) throws IOException {
        if (Flag.COUNT.equals(flag)) {
            this.addToCount(VarEncodingHelper.decodeVarDouble(input));
        } else if (Flag.SUM.equals(flag)) {
            this.addToSum(input.readDoubleLE());
        } else if (Flag.MIN.equals(flag)) {
            this.updateMin(input.readDoubleLE());
        } else if (Flag.MAX.equals(flag)) {
            this.updateMax(input.readDoubleLE());
        } else {
            DDSketch.throwInvalidFlagException(input, flag);
        }
    }

    private static final class DecodingState {
        private double count = 0.0;
        private double sum = 0.0;
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;

        private DecodingState() {
        }

        private void decodeSummaryStatistic(Input input, Flag flag) throws IOException {
            if (Flag.COUNT.equals(flag)) {
                this.count += VarEncodingHelper.decodeVarDouble(input);
            } else if (Flag.SUM.equals(flag)) {
                this.sum += input.readDoubleLE();
            } else if (Flag.MIN.equals(flag)) {
                this.min = Math.min(this.min, input.readDoubleLE());
            } else if (Flag.MAX.equals(flag)) {
                this.max = Math.max(this.max, input.readDoubleLE());
            } else {
                DDSketch.throwInvalidFlagException(input, flag);
            }
        }
    }
}

