/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.core.datastreams.DataStreamsMonitoring;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStreamContextInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataStreamContextInjector.class);
    private final DataStreamsMonitoring dataStreamsMonitoring;

    public DataStreamContextInjector(DataStreamsMonitoring dataStreamsMonitoring) {
        this.dataStreamsMonitoring = dataStreamsMonitoring;
    }

    public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags) {
        this.injectPathwayContext(span, carrier, setter, sortedTags, 0L, 0L, true);
    }

    public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags, long defaultTimestamp, long payloadSizeBytes) {
        this.injectPathwayContext(span, carrier, setter, sortedTags, defaultTimestamp, payloadSizeBytes, true);
    }

    public <C> void injectPathwayContextWithoutSendingStats(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags) {
        this.injectPathwayContext(span, carrier, setter, sortedTags, 0L, 0L, false);
    }

    private <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags, long defaultTimestamp, long payloadSizeBytes, boolean sendCheckpoint) {
        PathwayContext pathwayContext = span.context().getPathwayContext();
        if (pathwayContext == null || span.traceConfig() != null && !span.traceConfig().isDataStreamsEnabled()) {
            return;
        }
        pathwayContext.setCheckpoint(sortedTags, sendCheckpoint ? this.dataStreamsMonitoring::add : pathwayContext::saveStats, defaultTimestamp, payloadSizeBytes);
        boolean injected = DataStreamContextInjector.injectPathwayContext(pathwayContext, carrier, setter);
        if (injected && pathwayContext.getHash() != 0L) {
            span.setTag("pathway.hash", Long.toUnsignedString(pathwayContext.getHash()));
        }
    }

    private static <C> boolean injectPathwayContext(PathwayContext pathwayContext, C carrier, AgentPropagation.Setter<C> setter) {
        try {
            String encodedContext = pathwayContext.encode();
            if (encodedContext != null) {
                LOGGER.debug("Injecting pathway context {}", (Object)pathwayContext);
                setter.set(carrier, "dd-pathway-ctx-base64", encodedContext);
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.debug("Unable to set encode pathway context", (Throwable)e);
        }
        return false;
    }
}

