/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.dd.trace.api.flare.TracerFlare;
import ddtrot.dd.trace.common.writer.DDSpanJsonAdapter;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.core.DDSpan;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipOutputStream;

public class TraceDumpJsonExporter
implements Writer {
    private static final JsonAdapter<Collection<DDSpan>> TRACE_ADAPTER = new Moshi.Builder().add(DDSpanJsonAdapter.buildFactory(false)).build().adapter(Types.newParameterizedType(Collection.class, new Type[]{DDSpan.class}));
    private StringBuilder dumpText;
    private ZipOutputStream zip;

    public TraceDumpJsonExporter(ZipOutputStream zip) {
        this.zip = zip;
        this.dumpText = new StringBuilder();
    }

    public void write(Collection<DDSpan> trace) {
        this.dumpText.append(TRACE_ADAPTER.toJson(trace));
        this.dumpText.append('\n');
    }

    @Override
    public void write(List<DDSpan> trace) {
    }

    @Override
    public void start() {
    }

    @Override
    public boolean flush() {
        try {
            TracerFlare.addText(this.zip, "pending_traces.txt", this.dumpText.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public void incrementDropCounts(int spanCount) {
    }
}

