/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.json;

import ddtrot.dd.json.JsonStructure;
import java.util.BitSet;

class SafeJsonStructure
implements JsonStructure {
    private final BitSet structure = new BitSet();
    private int depth = -1;
    private boolean complete = false;

    SafeJsonStructure() {
    }

    @Override
    public void beginObject() {
        if (this.complete) {
            throw new IllegalStateException("Object is complete");
        }
        this.structure.set(++this.depth);
    }

    @Override
    public boolean objectStarted() {
        return this.depth >= 0 && this.structure.get(this.depth);
    }

    @Override
    public void endObject() {
        if (!this.objectStarted()) {
            throw new IllegalStateException("Object not started");
        }
        --this.depth;
        if (this.depth < 0) {
            this.complete = true;
        }
    }

    @Override
    public void beginArray() {
        if (this.complete) {
            throw new IllegalStateException("Object is complete");
        }
        this.structure.clear(++this.depth);
    }

    @Override
    public boolean arrayStarted() {
        return this.depth >= 0 && !this.structure.get(this.depth);
    }

    @Override
    public void endArray() {
        if (!this.arrayStarted()) {
            throw new IllegalStateException("Array not started");
        }
        --this.depth;
        if (this.depth < 0) {
            this.complete = true;
        }
    }

    @Override
    public void addName() {
        if (!this.objectStarted()) {
            throw new IllegalStateException("Object not started");
        }
    }

    @Override
    public void addValue() {
        if (this.complete) {
            throw new IllegalStateException("Object is complete");
        }
        if (this.depth < 0) {
            this.complete = true;
        }
    }

    public String toString() {
        return (this.complete ? "complete" : "") + this.structure;
    }
}

