/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.context.propagation;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.propagation.CarrierSetter;
import ddtrot.dd.context.propagation.CarrierVisitor;
import ddtrot.dd.context.propagation.Propagator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

class CompositePropagator
implements Propagator {
    private final Propagator[] propagators;

    CompositePropagator(Propagator[] propagators) {
        this.propagators = propagators;
    }

    @Override
    public <C> void inject(Context context, C carrier, CarrierSetter<C> setter) {
        for (Propagator propagator : this.propagators) {
            propagator.inject(context, carrier, setter);
        }
    }

    @Override
    public <C> Context extract(Context context, C carrier, CarrierVisitor<C> visitor) {
        CarrierCache carrierCache = new CarrierCache();
        visitor.forEachKeyValue(carrier, carrierCache);
        for (Propagator propagator : this.propagators) {
            context = propagator.extract(context, carrierCache, carrierCache);
        }
        return context;
    }

    static class CarrierCache
    implements BiConsumer<String, String>,
    CarrierVisitor<CarrierCache> {
        private final List<String> keysAndValues = new ArrayList<String>(32);

        @Override
        public void accept(String key, String value) {
            this.keysAndValues.add(key);
            this.keysAndValues.add(value);
        }

        @Override
        public void forEachKeyValue(CarrierCache carrier, BiConsumer<String, String> visitor) {
            for (int i = 0; i < carrier.keysAndValues.size() - 1; i += 2) {
                visitor.accept(carrier.keysAndValues.get(i), carrier.keysAndValues.get(i + 1));
            }
        }
    }
}

