/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.context;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.ContextKey;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class IndexedContext
implements Context {
    final Object[] store;

    IndexedContext(Object[] store) {
        this.store = store;
    }

    @Override
    @Nullable
    public <T> T get(ContextKey<T> key) {
        Objects.requireNonNull(key, "Context key cannot be null");
        int index = key.index;
        return (T)(index < this.store.length ? this.store[index] : null);
    }

    @Override
    public <T> Context with(ContextKey<T> key, @Nullable T value) {
        Objects.requireNonNull(key, "Context key cannot be null");
        int index = key.index;
        Object[] newStore = Arrays.copyOfRange(this.store, 0, Math.max(this.store.length, index + 1));
        newStore[index] = value;
        return new IndexedContext(newStore);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedContext that = (IndexedContext)o;
        return Arrays.equals(this.store, that.store);
    }

    public int hashCode() {
        int result = 31;
        result = 31 * result + Arrays.hashCode(this.store);
        return result;
    }

    public String toString() {
        return "IndexedContext{store=" + Arrays.toString(this.store) + '}';
    }
}

