/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.serialization.custom.stacktrace;

import ddtrot.dd.communication.serialization.EncodingCache;
import ddtrot.dd.communication.serialization.ValueWriter;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.trace.util.Strings;
import ddtrot.dd.trace.util.stacktrace.StackTraceEvent;

public class StackTraceEventWriter
implements ValueWriter<StackTraceEvent> {
    @Override
    public void write(StackTraceEvent value, Writable writable, EncodingCache encodingCache) {
        int mapSize = 1;
        boolean hasId = Strings.isNotBlank(value.getId());
        boolean hasLanguage = Strings.isNotBlank(value.getLanguage());
        boolean hasMessage = Strings.isNotBlank(value.getMessage());
        if (hasId) {
            ++mapSize;
        }
        if (hasLanguage) {
            ++mapSize;
        }
        if (hasMessage) {
            ++mapSize;
        }
        writable.startMap(mapSize);
        if (hasId) {
            writable.writeString("id", encodingCache);
            writable.writeString(value.getId(), encodingCache);
        }
        if (hasLanguage) {
            writable.writeString("language", encodingCache);
            writable.writeString(value.getLanguage(), encodingCache);
        }
        if (hasMessage) {
            writable.writeString("message", encodingCache);
            writable.writeString(value.getMessage(), encodingCache);
        }
        writable.writeString("frames", encodingCache);
        writable.writeObject(value.getFrames(), encodingCache);
    }
}

