/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.timgroup.statsd;

import ddtrot.com.timgroup.statsd.ClientChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import jnr.unixsocket.UnixSocketOptions;

public class UnixStreamClientChannel
implements ClientChannel {
    private final UnixSocketAddress address;
    private final int timeout;
    private final int connectionTimeout;
    private final int bufferSize;
    private SocketChannel delegate = null;
    private final ByteBuffer delimiterBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.LITTLE_ENDIAN);

    UnixStreamClientChannel(SocketAddress address, int timeout, int connectionTimeout, int bufferSize) throws IOException {
        this.address = (UnixSocketAddress)address;
        this.timeout = timeout;
        this.connectionTimeout = connectionTimeout;
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isConnected();
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        this.connectIfNeeded();
        int size = src.remaining();
        int written = 0;
        if (size == 0) {
            return 0;
        }
        this.delimiterBuffer.clear();
        this.delimiterBuffer.putInt(size);
        this.delimiterBuffer.flip();
        try {
            long deadline = System.nanoTime() + (long)this.timeout * 1000000L;
            written = this.writeAll(this.delimiterBuffer, true, deadline);
            if (written > 0) {
                written += this.writeAll(src, false, deadline);
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
        if (written == 0) {
            throw new IOException("Write timed out");
        }
        return size;
    }

    public int writeAll(ByteBuffer bb, boolean canReturnOnTimeout, long deadline) throws IOException {
        int remaining = bb.remaining();
        int written = 0;
        while (remaining > 0) {
            int read = this.delegate.write(bb);
            if (read == 0 && canReturnOnTimeout && written == 0) {
                return written;
            }
            remaining -= read;
            written += read;
            if (deadline <= 0L || System.nanoTime() <= deadline) continue;
            throw new IOException("Write timed out");
        }
        return written;
    }

    private void connectIfNeeded() throws IOException {
        if (this.delegate == null) {
            this.connect();
        }
    }

    private void disconnect() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
    }

    private void connect() throws IOException {
        if (this.delegate != null) {
            try {
                this.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        UnixSocketChannel delegate = UnixSocketChannel.create();
        long deadline = System.nanoTime() + (long)this.connectionTimeout * 1000000L;
        if (this.connectionTimeout > 0) {
            delegate.setOption(UnixSocketOptions.SO_SNDTIMEO, (Object)this.connectionTimeout);
        }
        try {
            if (!delegate.connect(this.address)) {
                if (this.connectionTimeout > 0 && System.nanoTime() > deadline) {
                    throw new IOException("Connection timed out");
                }
                if (!delegate.finishConnect()) {
                    throw new IOException("Connection failed");
                }
            }
            delegate.setOption(UnixSocketOptions.SO_SNDTIMEO, (Object)Math.max(this.timeout, 0));
            if (this.bufferSize > 0) {
                delegate.setOption(UnixSocketOptions.SO_SNDBUF, (Object)this.bufferSize);
            }
        }
        catch (Exception e) {
            try {
                delegate.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        this.delegate = delegate;
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    @Override
    public String getTransportType() {
        return "uds-stream";
    }

    public String toString() {
        return "[" + this.getTransportType() + "] " + this.address;
    }

    @Override
    public int getMaxPacketSizeBytes() {
        return 8192;
    }
}

