/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.db;

import datadog.trace.bootstrap.instrumentation.jdbc.DBQueryInfo;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.db.SqlStatementInfo;

public final class SqlStatementSanitizer {
    private final boolean sanitizationEnabled;

    public static SqlStatementSanitizer create(boolean sanitizationEnabled) {
        return new SqlStatementSanitizer(sanitizationEnabled);
    }

    private SqlStatementSanitizer(boolean sanitizationEnabled) {
        this.sanitizationEnabled = sanitizationEnabled;
    }

    public SqlStatementInfo sanitize(String statement) {
        if (this.sanitizationEnabled) {
            DBQueryInfo dbQueryInfo = DBQueryInfo.ofPreparedStatement(statement);
            return SqlStatementInfo.create(dbQueryInfo.getSql().toString(), dbQueryInfo.getOperation().toString(), null);
        }
        return SqlStatementInfo.create(statement, null, null);
    }
}

