/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator.http;

import datadog.trace.api.Config;
import datadog.trace.api.normalize.HttpResourceNames;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.URIUtils;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;

public class HttpResourceDecorator {
    public static final HttpResourceDecorator HTTP_RESOURCE_DECORATOR = new HttpResourceDecorator();
    private static final UTF8BytesString DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");
    private final boolean shouldSetUrlResourceName = Config.get().isRuleEnabled("URLAsResourceNameRule");

    private HttpResourceDecorator() {
    }

    public final AgentSpan withClientPath(AgentSpan span, CharSequence method, CharSequence path) {
        return HttpResourceNames.setForClient(span, method, path, false);
    }

    public final AgentSpan withServerPath(AgentSpan span, CharSequence method, CharSequence path, boolean encoded) {
        if (!this.shouldSetUrlResourceName) {
            return span.setResourceName(DEFAULT_RESOURCE_NAME);
        }
        return HttpResourceNames.setForServer(span, method, path, encoded);
    }

    public final AgentSpan withRoute(AgentSpan span, CharSequence method, CharSequence route) {
        return this.withRoute(span, method, route, false);
    }

    public final AgentSpan withRoute(AgentSpan span, CharSequence method, CharSequence route, boolean encoded) {
        CharSequence routeTag = route;
        if (encoded) {
            routeTag = URIUtils.decode(route.toString());
        }
        span.setTag("http.route", routeTag);
        if (Config.get().isHttpServerRouteBasedNaming()) {
            CharSequence resourceName = HttpResourceNames.join(method, route);
            span.setResourceName(resourceName, (byte)3);
        }
        return span;
    }
}

