/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.telemetry;

import datadog.trace.api.metrics.BaggageMetrics;
import datadog.trace.api.metrics.CoreCounter;
import datadog.trace.api.metrics.SpanMetricRegistryImpl;
import datadog.trace.api.metrics.SpanMetricsImpl;
import datadog.trace.api.telemetry.MetricCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class CoreMetricCollector
implements MetricCollector<CoreMetric> {
    private static final String METRIC_NAMESPACE = "tracers";
    private static final String INTEGRATION_NAME_TAG = "integration_name:";
    private static final CoreMetricCollector INSTANCE = new CoreMetricCollector();
    private final SpanMetricRegistryImpl spanMetricRegistry = SpanMetricRegistryImpl.getInstance();
    private final BaggageMetrics baggageMetrics = BaggageMetrics.getInstance();
    private final BlockingQueue<CoreMetric> metricsQueue = new ArrayBlockingQueue<CoreMetric>(1024);

    public static CoreMetricCollector getInstance() {
        return INSTANCE;
    }

    private CoreMetricCollector() {
    }

    @Override
    public void prepareMetrics() {
        for (SpanMetricsImpl spanMetrics : this.spanMetricRegistry.getSpanMetrics()) {
            CoreMetric metric;
            CoreCounter counter;
            long value;
            String tag = INTEGRATION_NAME_TAG + spanMetrics.getInstrumentationName();
            Iterator<CoreCounter> iterator = spanMetrics.getCounters().iterator();
            while (iterator.hasNext() && ((value = (counter = iterator.next()).getValueAndReset()) == 0L || this.metricsQueue.offer(metric = new CoreMetric(METRIC_NAMESPACE, true, counter.getName(), "count", (Number)value, tag)))) {
            }
        }
        for (BaggageMetrics.TaggedCounter counter : this.baggageMetrics.getTaggedCounters()) {
            long value = counter.getValueAndReset();
            if (value == 0L) continue;
            String tag = counter.getTag();
            CoreMetric metric = new CoreMetric(METRIC_NAMESPACE, true, counter.getName(), "count", (Number)value, tag);
            if (this.metricsQueue.offer(metric)) continue;
            break;
        }
    }

    @Override
    public Collection<CoreMetric> drain() {
        if (this.metricsQueue.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CoreMetric> drained = new ArrayList<CoreMetric>(this.metricsQueue.size());
        this.metricsQueue.drainTo(drained);
        return drained;
    }

    public static class CoreMetric
    extends MetricCollector.Metric {
        public CoreMetric(String namespace, boolean common, String metricName, String type, Number value, String tag) {
            super(namespace, common, metricName, type, value, tag);
        }
    }
}

