/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.http;

import datadog.trace.bootstrap.otel.api.common.AttributeKey;
import datadog.trace.bootstrap.otel.api.common.AttributesBuilder;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.net.internal.UrlParser;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.AttributesExtractor;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class HttpClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final AttributeKey<String> PEER_SERVICE = AttributeKey.stringKey("peer.service");
    private final HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private final PeerServiceResolver peerServiceResolver;

    HttpClientPeerServiceAttributesExtractor(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, PeerServiceResolver peerServiceResolver) {
        this.attributesGetter = attributesGetter;
        this.peerServiceResolver = peerServiceResolver;
    }

    public static <REQUEST, RESPONSE> HttpClientPeerServiceAttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, PeerServiceResolver peerServiceResolver) {
        return new HttpClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>(attributesGetter, peerServiceResolver);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Supplier<String> pathSupplier;
        Integer serverPort;
        if (this.peerServiceResolver.isEmpty()) {
            return;
        }
        String serverAddress = this.attributesGetter.getServerAddress(request);
        String peerService = this.mapToPeerService(serverAddress, serverPort = this.attributesGetter.getServerPort(request), pathSupplier = () -> this.getUrlPath(this.attributesGetter, request));
        if (peerService != null) {
            attributes.put(PEER_SERVICE, peerService);
        }
    }

    @Nullable
    private String mapToPeerService(@Nullable String host, @Nullable Integer port, @Nullable Supplier<String> pathSupplier) {
        if (host == null) {
            return null;
        }
        return this.peerServiceResolver.resolveService(host, port, pathSupplier);
    }

    @Nullable
    private String getUrlPath(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, REQUEST request) {
        String urlFull = attributesGetter.getUrlFull(request);
        if (urlFull == null) {
            return null;
        }
        return UrlParser.getPath(urlFull);
    }
}

