/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.git;

import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.civisibility.InstrumentationBridge;
import datadog.trace.api.civisibility.telemetry.CiVisibilityCountMetric;
import datadog.trace.api.civisibility.telemetry.tag.GitProviderDiscrepant;
import datadog.trace.api.civisibility.telemetry.tag.GitProviderExpected;
import datadog.trace.api.civisibility.telemetry.tag.GitShaDiscrepancyType;
import datadog.trace.api.civisibility.telemetry.tag.GitShaMatch;
import datadog.trace.api.git.CommitInfo;
import datadog.trace.api.git.GitInfo;
import datadog.trace.api.git.GitInfoBuilder;
import datadog.trace.api.git.GitUtils;
import datadog.trace.api.git.PersonInfo;
import datadog.trace.api.git.UserSuppliedGitInfoBuilder;
import datadog.trace.util.Strings;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class GitInfoProvider {
    public static final GitInfoProvider INSTANCE = new GitInfoProvider();
    static final String NULL_PATH_STRING;
    private volatile Collection<GitInfoBuilder> builders = Collections.emptyList();
    private final DDCache<String, GitInfo> gitInfoCache = DDCaches.newFixedSizeCache(4);

    public GitInfo getGitInfo() {
        return this.getGitInfo(null);
    }

    public GitInfo getGitInfo(@Nullable String repositoryPath) {
        if (repositoryPath == null) {
            repositoryPath = NULL_PATH_STRING;
        }
        return this.gitInfoCache.computeIfAbsent(repositoryPath, this::buildGitInfo);
    }

    private GitInfo buildGitInfo(String repositoryPath) {
        Evaluator evaluator = new Evaluator(repositoryPath, this.builders);
        GitInfo gitInfo = new GitInfo(evaluator.get(gi -> GitUtils.filterSensitiveInfo(gi.getRepositoryURL()), GitInfoProvider::validateGitRemoteUrl), evaluator.get(GitInfo::getBranch, Strings::isNotBlank), evaluator.get(GitInfo::getTag, Strings::isNotBlank), new CommitInfo(evaluator.get(gi1 -> gi1.getCommit().getSha(), Strings::isNotBlank), new PersonInfo(evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getAuthor().getName(), Strings::isNotBlank), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getAuthor().getEmail(), Strings::isNotBlank), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getAuthor().getIso8601Date(), Strings::isNotBlank)), new PersonInfo(evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getCommitter().getName(), Strings::isNotBlank), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getCommitter().getEmail(), Strings::isNotBlank), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getCommitter().getIso8601Date(), Strings::isNotBlank)), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getFullMessage(), Strings::isNotBlank)));
        InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.GIT_COMMIT_SHA_MATCH, 1L, evaluator.shaDiscrepancies.isEmpty() ? GitShaMatch.TRUE : GitShaMatch.FALSE);
        for (ShaDiscrepancy mismatch : evaluator.shaDiscrepancies) {
            mismatch.addTelemetry();
        }
        return gitInfo;
    }

    private static boolean validateGitRemoteUrl(String s) {
        return Strings.isNotBlank(s) && !s.startsWith("file:");
    }

    public synchronized void registerGitInfoBuilder(GitInfoBuilder builder) {
        ArrayList<GitInfoBuilder> updatedBuilders = new ArrayList<GitInfoBuilder>(this.builders);
        updatedBuilders.add(builder);
        updatedBuilders.sort(Comparator.comparingInt(GitInfoBuilder::order));
        this.builders = updatedBuilders;
        this.gitInfoCache.clear();
    }

    public synchronized void invalidateCache() {
        this.gitInfoCache.clear();
    }

    static {
        INSTANCE.registerGitInfoBuilder(new UserSuppliedGitInfoBuilder());
        NULL_PATH_STRING = Paths.get("", new String[0]).toAbsolutePath().toString();
    }

    private static final class Evaluator {
        private final String repositoryPath;
        private final Map<GitInfoBuilder, GitInfo> infos;
        private final Set<ShaDiscrepancy> shaDiscrepancies;

        private Evaluator(String repositoryPath, Collection<GitInfoBuilder> builders) {
            this.repositoryPath = repositoryPath;
            this.infos = new LinkedHashMap<GitInfoBuilder, GitInfo>();
            this.shaDiscrepancies = new HashSet<ShaDiscrepancy>();
            for (GitInfoBuilder builder : builders) {
                this.infos.put(builder, null);
            }
        }

        private String get(Function<GitInfo, String> function, Predicate<String> validator) {
            return this.get(function, validator, false);
        }

        private String getIfCommitShaMatches(Function<GitInfo, String> function, Predicate<String> validator) {
            return this.get(function, validator, true);
        }

        private String get(Function<GitInfo, String> function, Predicate<String> validator, boolean checkShaIntegrity) {
            String expectedCommitSha = null;
            String expectedRepoUrl = null;
            GitProviderExpected expectedGitProvider = null;
            for (Map.Entry<GitInfoBuilder, GitInfo> e : this.infos.entrySet()) {
                String result;
                GitInfo info = e.getValue();
                if (info == null) {
                    GitInfoBuilder builder = e.getKey();
                    info = builder.build(this.repositoryPath);
                    e.setValue(info);
                }
                if (checkShaIntegrity) {
                    String currentCommitSha;
                    CommitInfo currentCommit = info.getCommit();
                    String string = currentCommitSha = currentCommit != null ? currentCommit.getSha() : null;
                    if (Strings.isNotBlank(currentCommitSha)) {
                        if (expectedCommitSha == null) {
                            expectedCommitSha = currentCommitSha;
                            expectedRepoUrl = info.getRepositoryURL();
                            expectedGitProvider = e.getKey().providerAsExpected();
                        } else if (!expectedCommitSha.equals(currentCommitSha)) {
                            GitShaDiscrepancyType discrepancyType = GitShaDiscrepancyType.COMMIT_DISCREPANCY;
                            String repoUrl = info.getRepositoryURL();
                            if (expectedRepoUrl != null && repoUrl != null && !repoUrl.equals(expectedRepoUrl)) {
                                discrepancyType = GitShaDiscrepancyType.REPOSITORY_DISCREPANCY;
                            }
                            this.shaDiscrepancies.add(new ShaDiscrepancy(expectedGitProvider, e.getKey().providerAsDiscrepant(), discrepancyType));
                            continue;
                        }
                    }
                }
                if (!validator.test(result = function.apply(info))) continue;
                return result;
            }
            return null;
        }
    }

    private static final class ShaDiscrepancy {
        private final GitProviderExpected expectedGitProvider;
        private final GitProviderDiscrepant discrepantGitProvider;
        private final GitShaDiscrepancyType discrepancyType;

        private ShaDiscrepancy(GitProviderExpected expectedGitProvider, GitProviderDiscrepant discrepantGitProvider, GitShaDiscrepancyType discrepancyType) {
            this.expectedGitProvider = expectedGitProvider;
            this.discrepantGitProvider = discrepantGitProvider;
            this.discrepancyType = discrepancyType;
        }

        private void addTelemetry() {
            InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.GIT_COMMIT_SHA_DISCREPANCY, 1L, this.expectedGitProvider, this.discrepantGitProvider, this.discrepancyType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ShaDiscrepancy that = (ShaDiscrepancy)obj;
            return this.expectedGitProvider.equals(that.expectedGitProvider) && this.discrepantGitProvider.equals(that.discrepantGitProvider) && this.discrepancyType.equals(that.discrepancyType);
        }

        public int hashCode() {
            return Objects.hash(this.expectedGitProvider, this.discrepantGitProvider, this.discrepancyType);
        }
    }
}

