/*
 * Decompiled with CFR 0.152.
 */
package datadog.context.propagation;

import datadog.context.propagation.CompositePropagator;
import datadog.context.propagation.Concern;
import datadog.context.propagation.NoopPropagator;
import datadog.context.propagation.Propagator;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;

public final class Propagators {
    private static final Map<Concern, RegisteredPropagator> PROPAGATORS = Collections.synchronizedMap(new IdentityHashMap());
    private static final RegisteredPropagator NOOP = RegisteredPropagator.of(NoopPropagator.INSTANCE, false);
    private static volatile Propagator defaultPropagator = null;
    private static volatile boolean rebuildDefaultPropagator = true;

    private Propagators() {
    }

    public static Propagator defaultPropagator() {
        if (rebuildDefaultPropagator) {
            Propagator[] propagatorsByPriority = (Propagator[])PROPAGATORS.entrySet().stream().filter(entry -> ((RegisteredPropagator)entry.getValue()).isUsedAsDefault()).sorted(Comparator.comparingInt(entry -> ((Concern)entry.getKey()).priority())).map(Map.Entry::getValue).map(RegisteredPropagator::propagator).toArray(Propagator[]::new);
            defaultPropagator = Propagators.composite(propagatorsByPriority);
            rebuildDefaultPropagator = false;
        }
        return defaultPropagator;
    }

    public static Propagator forConcern(Concern concern) {
        return PROPAGATORS.getOrDefault(concern, NOOP).propagator();
    }

    public static Propagator forConcerns(Concern ... concerns) {
        Propagator[] propagators = new Propagator[concerns.length];
        for (int i = 0; i < concerns.length; ++i) {
            propagators[i] = Propagators.forConcern(concerns[i]);
        }
        return Propagators.composite(propagators);
    }

    public static Propagator noop() {
        return NoopPropagator.INSTANCE;
    }

    public static Propagator composite(Propagator ... propagators) {
        if (propagators.length == 0) {
            return NoopPropagator.INSTANCE;
        }
        if (propagators.length == 1) {
            return propagators[0];
        }
        return new CompositePropagator(propagators);
    }

    public static void register(Concern concern, Propagator propagator) {
        Propagators.register(concern, propagator, true);
    }

    public static void register(Concern concern, Propagator propagator, boolean usedAsDefault) {
        PROPAGATORS.put(concern, RegisteredPropagator.of(propagator, usedAsDefault));
        if (usedAsDefault) {
            rebuildDefaultPropagator = true;
        }
    }

    static void reset() {
        PROPAGATORS.clear();
        rebuildDefaultPropagator = true;
    }

    static class RegisteredPropagator {
        private final Propagator propagator;
        private final boolean usedAsDefault;

        private RegisteredPropagator(Propagator propagator, boolean usedAsDefault) {
            this.propagator = propagator;
            this.usedAsDefault = usedAsDefault;
        }

        static RegisteredPropagator of(Propagator propagator, boolean useAsDefault) {
            return new RegisteredPropagator(propagator, useAsDefault);
        }

        Propagator propagator() {
            return this.propagator;
        }

        boolean isUsedAsDefault() {
            return this.usedAsDefault;
        }
    }
}

