/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.http;

import datadog.trace.bootstrap.PatchLogger;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.metrics.LongHistogram;
import datadog.trace.bootstrap.otel.api.metrics.LongHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.Meter;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.ContextKey;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.http.HttpExperimentalMetricsAdvice;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.http.HttpMessageBodySizeUtil;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationListener;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationMetrics;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.OperationMetricsUtil;
import java.util.logging.Level;

public final class HttpClientExperimentalMetrics
implements OperationListener {
    private static final ContextKey<Attributes> HTTP_CLIENT_REQUEST_METRICS_START_ATTRIBUTES = ContextKey.named("http-client-experimental-metrics-start-attributes");
    private static final PatchLogger logger = PatchLogger.getLogger(HttpClientExperimentalMetrics.class.getName());
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        return OperationMetricsUtil.create("experimental http client", HttpClientExperimentalMetrics::new);
    }

    private HttpClientExperimentalMetrics(Meter meter) {
        LongHistogramBuilder requestSizeBuilder = meter.histogramBuilder("http.client.request.size").setUnit("By").setDescription("Size of HTTP client request bodies.").ofLongs();
        HttpExperimentalMetricsAdvice.applyClientRequestSizeAdvice(requestSizeBuilder);
        this.requestSize = requestSizeBuilder.build();
        LongHistogramBuilder responseSizeBuilder = meter.histogramBuilder("http.client.response.size").setUnit("By").setDescription("Size of HTTP client response bodies.").ofLongs();
        HttpExperimentalMetricsAdvice.applyClientRequestSizeAdvice(responseSizeBuilder);
        this.responseSize = responseSizeBuilder.build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_CLIENT_REQUEST_METRICS_START_ATTRIBUTES, startAttributes);
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseBodySize;
        Attributes startAttributes = context.get(HTTP_CLIENT_REQUEST_METRICS_START_ATTRIBUTES);
        if (startAttributes == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes sizeAttributes = startAttributes.toBuilder().putAll(endAttributes).build();
        Long requestBodySize = HttpMessageBodySizeUtil.getHttpRequestBodySize(endAttributes, startAttributes);
        if (requestBodySize != null) {
            this.requestSize.record(requestBodySize, sizeAttributes, context);
        }
        if ((responseBodySize = HttpMessageBodySizeUtil.getHttpResponseBodySize(endAttributes, startAttributes)) != null) {
            this.responseSize.record(responseBodySize, sizeAttributes, context);
        }
    }
}

