/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classmatch;

import datadog.instrument.classmatch.AccessMatcher;
import datadog.instrument.classmatch.ClassMatcher;
import datadog.instrument.classmatch.FieldMatcher;
import datadog.instrument.classmatch.MethodMatcher;
import datadog.instrument.classmatch.TypeMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;

public final class StandardMatchers {
    private StandardMatchers() {
    }

    public static TypeMatcher not(TypeMatcher matcher) {
        return cs -> !matcher.test(cs);
    }

    public static ClassMatcher not(ClassMatcher matcher) {
        return c -> !matcher.test(c);
    }

    public static FieldMatcher not(FieldMatcher matcher) {
        return f -> !matcher.test(f);
    }

    public static MethodMatcher not(MethodMatcher matcher) {
        return m -> !matcher.test(m);
    }

    public static AccessMatcher not(AccessMatcher matcher) {
        return acc -> !matcher.test(acc);
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static Predicate<String> named(String name) {
        return name::equals;
    }

    public static Predicate<String> namedOneOf(String ... names) {
        return StandardMatchers.namedOneOf(Arrays.asList(names));
    }

    public static Predicate<String> namedOneOf(Collection<String> names) {
        return new HashSet<String>(names)::contains;
    }

    public static Predicate<String> nameStartsWith(String prefix) {
        return s -> s.startsWith(prefix);
    }

    public static Predicate<String> nameEndsWith(String suffix) {
        return s -> s.endsWith(suffix);
    }
}

