/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.java.concurrent.ContinuationClaim;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class ConcurrentState {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentState.class);
    public static ContextStore.Factory<ConcurrentState> FACTORY = ConcurrentState::new;
    private volatile AgentScope.Continuation continuation = null;
    private static final AtomicReferenceFieldUpdater<ConcurrentState, AgentScope.Continuation> CONTINUATION = AtomicReferenceFieldUpdater.newUpdater(ConcurrentState.class, AgentScope.Continuation.class, "continuation");

    private ConcurrentState() {
    }

    public static <K> ConcurrentState captureContinuation(ContextStore<K, ConcurrentState> contextStore, K key, AgentSpan span) {
        if (span == null || !span.isValid() || !AgentTracer.isAsyncPropagationEnabled()) {
            return null;
        }
        ConcurrentState state = contextStore.putIfAbsent(key, FACTORY);
        if (!state.captureAndSetContinuation(span) && log.isDebugEnabled()) {
            log.debug("continuation was already set for {} in span {}, no continuation captured.", (Object)key, (Object)span);
        }
        return state;
    }

    public static <K> AgentScope activateAndContinueContinuation(ContextStore<K, ConcurrentState> contextStore, K key) {
        ConcurrentState state = contextStore.get(key);
        if (state == null) {
            return null;
        }
        return state.activateAndContinueContinuation();
    }

    public static <K> void closeScope(ContextStore<K, ConcurrentState> contextStore, K key, AgentScope scope, Throwable throwable) {
        ConcurrentState state = contextStore.get(key);
        if (scope != null) {
            scope.close();
            return;
        }
        if (state == null) {
            return;
        }
        if (throwable != null) {
            state.cancelContinuation();
        }
    }

    public static <K> void cancelAndClearContinuation(ContextStore<K, ConcurrentState> contextStore, K key) {
        ConcurrentState state = contextStore.get(key);
        if (state == null) {
            return;
        }
        state.cancelAndClearContinuation();
    }

    private boolean captureAndSetContinuation(AgentSpan span) {
        if (CONTINUATION.compareAndSet(this, null, ContinuationClaim.CLAIMED)) {
            CONTINUATION.lazySet(this, AgentTracer.captureSpan(span).hold());
            return true;
        }
        return false;
    }

    private AgentScope activateAndContinueContinuation() {
        AgentScope.Continuation continuation = CONTINUATION.get(this);
        if (continuation != null && continuation != ContinuationClaim.CLAIMED) {
            return continuation.activate();
        }
        return null;
    }

    private void cancelContinuation() {
        AgentScope.Continuation continuation = CONTINUATION.get(this);
        if (continuation != null && continuation != ContinuationClaim.CLAIMED) {
            continuation.cancel();
        }
    }

    private void cancelAndClearContinuation() {
        AgentScope.Continuation continuation = CONTINUATION.get(this);
        if (continuation != null && continuation != ContinuationClaim.CLAIMED) {
            CONTINUATION.compareAndSet(this, continuation, ContinuationClaim.CLAIMED);
            continuation.cancel();
        }
    }
}

