/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.normalize;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.BitSet;

public final class SQLNormalizer {
    private static final Logger log;
    private static final BitSet NUMERIC_LITERAL_PREFIX;
    private static final BitSet SPLITTERS;

    public static UTF8BytesString normalizeCharSequence(CharSequence sql) {
        return SQLNormalizer.normalize(sql.toString());
    }

    public static UTF8BytesString normalize(String sql) {
        byte[] utf8 = sql.getBytes(StandardCharsets.UTF_8);
        try {
            int outputLength;
            BitSet splitters = SQLNormalizer.findSplitterPositions(utf8);
            int end = outputLength = utf8.length;
            int start = end > 0 ? splitters.previousSetBit(end - 1) : -1;
            boolean modified = false;
            while (end > 0 && start > 0) {
                int sequenceEnd = end - 1;
                int sequenceStart = start + 1;
                if (sequenceEnd == sequenceStart) {
                    if (Character.isDigit(utf8[sequenceStart])) {
                        utf8[sequenceStart] = 63;
                        modified = true;
                    }
                } else if (sequenceStart < sequenceEnd && (SQLNormalizer.isQuoted(utf8, sequenceStart, sequenceEnd) || SQLNormalizer.isNumericLiteralPrefix(utf8, sequenceStart) || SQLNormalizer.isHexLiteralPrefix(utf8, sequenceStart, sequenceEnd))) {
                    int length = sequenceEnd - sequenceStart;
                    System.arraycopy(utf8, end, utf8, sequenceStart + 1, outputLength - end);
                    utf8[sequenceStart] = 63;
                    outputLength -= length;
                    modified = true;
                }
                end = start;
                start = splitters.previousSetBit(start - 1);
            }
            if (modified) {
                return UTF8BytesString.create(Arrays.copyOf(utf8, outputLength));
            }
        }
        catch (Throwable paranoid) {
            log.debug("Error normalizing sql {}", (Object)sql, (Object)paranoid);
        }
        return UTF8BytesString.create(sql, utf8);
    }

    private static boolean isQuoted(byte[] utf8, int start, int end) {
        return utf8[start] == 39 && utf8[end] == 39;
    }

    private static boolean isHexLiteralPrefix(byte[] utf8, int start, int end) {
        return (utf8[start] | 0x20) == 120 && start + 1 < end && utf8[start + 1] == 39;
    }

    private static boolean isNumericLiteralPrefix(byte[] utf8, int start) {
        return NUMERIC_LITERAL_PREFIX.get(utf8[start] & 0xFF) && (utf8[start + 1] != 45 || utf8[start] != 45);
    }

    private static boolean isSplitter(byte symbol) {
        return SPLITTERS.get(symbol & 0xFF);
    }

    private static BitSet findSplitterPositions(byte[] utf8) {
        BitSet positions = new BitSet(utf8.length);
        boolean quoted = false;
        boolean escaped = false;
        for (int i = 0; i < utf8.length; ++i) {
            byte b = utf8[i];
            if (b == 39 && !escaped) {
                quoted = !quoted;
                continue;
            }
            escaped = b == 92 & !escaped;
            positions.set(i, !quoted & SQLNormalizer.isSplitter(b));
        }
        return positions;
    }

    static {
        int unsigned;
        log = LoggerFactory.getLogger(SQLNormalizer.class);
        NUMERIC_LITERAL_PREFIX = new BitSet();
        SPLITTERS = new BitSet();
        for (byte symbol : new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 43, 46}) {
            unsigned = symbol & 0xFF;
            NUMERIC_LITERAL_PREFIX.set(unsigned);
        }
        for (byte symbol : new byte[]{44, 40, 41, 124}) {
            unsigned = symbol & 0xFF;
            SPLITTERS.set(unsigned);
        }
        for (int i = 0; i < 256; ++i) {
            if (!Character.isWhitespace((char)i)) continue;
            SPLITTERS.set(i);
        }
    }
}

