/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.semconv.http;

import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HeaderParsingHelper;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HttpCommonAttributesExtractor;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HttpCommonAttributesGetter;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;

final class HostAddressAndPortExtractor<REQUEST>
implements AddressAndPortExtractor<REQUEST> {
    private final HttpCommonAttributesGetter<REQUEST, ?> getter;

    HostAddressAndPortExtractor(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public void extract(AddressAndPortExtractor.AddressPortSink sink, REQUEST request) {
        String host = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "host"));
        if (host == null) {
            return;
        }
        int hostHeaderSeparator = host.indexOf(58);
        if (hostHeaderSeparator == -1) {
            sink.setAddress(host);
        } else {
            sink.setAddress(host.substring(0, hostHeaderSeparator));
            HeaderParsingHelper.setPort(sink, host, hostHeaderSeparator + 1, host.length());
        }
    }
}

