/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.backpressure;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.TaskWrapper;
import datadog.trace.bootstrap.instrumentation.jfr.backpressure.BackpressureSampleEvent;
import datadog.trace.bootstrap.instrumentation.jfr.backpressure.BackpressureSampler;

public final class BackpressureProfiling {
    private final BackpressureSampler sampler;

    public static BackpressureProfiling getInstance() {
        return Holder.INSTANCE;
    }

    private BackpressureProfiling(Config config) {
        this(new BackpressureSampler(config));
    }

    BackpressureProfiling(BackpressureSampler sampler) {
        this.sampler = sampler;
    }

    public void start() {
        this.sampler.start();
    }

    public void process(Class<?> backpressureMechanism, Object task) {
        if (this.sampler.sample()) {
            new BackpressureSampleEvent(backpressureMechanism, TaskWrapper.getUnwrappedType(task)).commit();
        }
    }

    private static final class Holder {
        static final BackpressureProfiling INSTANCE = new BackpressureProfiling(Config.get());

        private Holder() {
        }
    }
}

