/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.environment.JavaVirtualMachine;
import datadog.environment.SystemProperties;

public final class Platform {
    private static final boolean HAS_JFR = Platform.checkForJfr();
    private static final boolean IS_NATIVE_IMAGE_BUILDER = Platform.checkForNativeImageBuilder();
    private static final boolean IS_NATIVE_IMAGE = Captured.isNativeImage;

    public static boolean hasJfr() {
        return HAS_JFR;
    }

    public static boolean isNativeImageBuilder() {
        return IS_NATIVE_IMAGE_BUILDER;
    }

    public static boolean isNativeImage() {
        return IS_NATIVE_IMAGE;
    }

    private static boolean checkForJfr() {
        try {
            return (JavaVirtualMachine.isJavaVersion(8) && JavaVirtualMachine.isJavaVersionAtLeast(8, 0, 272) || JavaVirtualMachine.isJavaVersionAtLeast(11)) && !JavaVirtualMachine.isJ9() && !JavaVirtualMachine.isOracleJDK8();
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean checkForNativeImageBuilder() {
        try {
            return "org.graalvm.nativeimage.builder".equals(SystemProperties.get("jdk.module.main"));
        }
        catch (Throwable e) {
            return false;
        }
    }

    static /* synthetic */ boolean access$000() {
        return Platform.checkForNativeImageBuilder();
    }

    private static class Captured {
        public static final boolean isNativeImage = Platform.access$000();

        private Captured() {
        }
    }
}

