/*
 * Decompiled with CFR 0.152.
 */
package datadog.environment;

import datadog.environment.SystemProperties;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class CommandLine {
    private static final String SUN_JAVA_COMMAND_PROPERTY = "sun.java.command";
    private final List<String> fullCommand = this.findFullCommand();
    final String name = this.getCommandName();
    final List<String> arguments = this.getCommandArguments();

    CommandLine() {
    }

    @SuppressForbidden
    private List<String> findFullCommand() {
        String command = SystemProperties.getOrDefault(SUN_JAVA_COMMAND_PROPERTY, "").trim();
        return command.isEmpty() ? Collections.emptyList() : Arrays.asList(command.split(" "));
    }

    private String getCommandName() {
        return this.fullCommand.isEmpty() ? null : this.fullCommand.get(0);
    }

    private List<String> getCommandArguments() {
        if (this.fullCommand.isEmpty()) {
            return this.fullCommand;
        }
        return this.fullCommand.subList(1, this.fullCommand.size());
    }
}

