/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.context.propagation;

import datadog.context.propagation.Propagators;
import datadog.trace.api.TracePropagationStyle;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanContext;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import datadog.trace.bootstrap.otel.api.trace.TraceState;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.propagation.TextMapGetter;
import datadog.trace.bootstrap.otel.context.propagation.TextMapPropagator;
import datadog.trace.bootstrap.otel.context.propagation.TextMapSetter;
import datadog.trace.bootstrap.otel.shim.context.OtelContext;
import datadog.trace.bootstrap.otel.shim.context.propagation.TraceStateHelper;
import datadog.trace.bootstrap.otel.shim.trace.OtelExtractedContext;
import datadog.trace.util.PropagationUtils;
import java.util.Collection;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AgentTextMapPropagator
implements TextMapPropagator {
    @Override
    public Collection<String> fields() {
        return PropagationUtils.KNOWN_PROPAGATION_HEADERS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (carrier == null) {
            return;
        }
        Propagators.defaultPropagator().inject(AgentTextMapPropagator.convertContext(context), carrier, setter::set);
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        if (carrier == null) {
            return context;
        }
        datadog.context.Context extracted = Propagators.defaultPropagator().extract(AgentTextMapPropagator.convertContext(context), carrier, (C carrier1, BiConsumer<String, String> classifier) -> {
            for (String key : getter.keys(carrier1)) {
                classifier.accept(key, getter.get(carrier1, key));
            }
        });
        return new OtelContext(extracted);
    }

    private static datadog.context.Context convertContext(Context context) {
        if (context instanceof OtelContext) {
            return ((OtelContext)context).asContext();
        }
        AgentSpanContext extract = OtelExtractedContext.extract(context);
        return AgentSpan.fromSpanContext(extract);
    }

    private static <C> TraceState extractTraceState(AgentSpanContext.Extracted extracted, C carrier, TextMapGetter<C> getter) {
        String header;
        return extracted instanceof TagContext && TracePropagationStyle.TRACECONTEXT.equals((Object)((TagContext)extracted).getPropagationStyle()) && (header = getter.get(carrier, "tracestate")) != null ? TraceStateHelper.decodeHeader(header) : TraceState.getDefault();
    }
}

