/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.servlet;

import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.ContextKey;
import java.util.function.Function;

public final class ServletContextPath {
    private static final ContextKey<ServletContextPath> CONTEXT_KEY = ContextKey.named("opentelemetry-servlet-context-path-key");
    private final String contextPath;

    public static <REQUEST> Context init(Context context, Function<REQUEST, String> contextPathExtractor, REQUEST request) {
        ServletContextPath servletContextPath = context.get(CONTEXT_KEY);
        if (servletContextPath != null) {
            return context;
        }
        String contextPath = contextPathExtractor.apply(request);
        if (contextPath == null) {
            return context;
        }
        if (contextPath.isEmpty() || contextPath.equals("/")) {
            contextPath = null;
        }
        return context.with(CONTEXT_KEY, new ServletContextPath(contextPath));
    }

    private ServletContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public static String prepend(Context context, String spanName) {
        String value;
        ServletContextPath servletContextPath = context.get(CONTEXT_KEY);
        if (servletContextPath != null && (value = servletContextPath.contextPath) != null) {
            if (spanName == null || spanName.isEmpty()) {
                return value;
            }
            return value + (spanName.startsWith("/") ? spanName : "/" + spanName);
        }
        return spanName;
    }
}

