/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.internal;

import datadog.trace.bootstrap.PatchLogger;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.Meter;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationListener;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationMetrics;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;

public class OperationMetricsUtil {
    private static final PatchLogger logger = PatchLogger.getLogger(OperationMetricsUtil.class.getName());
    private static final OperationListener NOOP_OPERATION_LISTENER = new OperationListener(){

        @Override
        public Context onStart(Context context, Attributes startAttributes, long startNanos) {
            return context;
        }

        @Override
        public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        }
    };

    public static OperationMetrics create(String description, Function<Meter, OperationListener> factory) {
        return OperationMetricsUtil.create(description, factory, (s, histogramBuilder) -> logger.log(Level.WARNING, "Disabling {0} metrics because {1} does not implement {2}. This prevents using metrics advice, which could result in {0} metrics having high cardinality attributes.", new Object[]{description, histogramBuilder.getClass().getName(), ExtendedDoubleHistogramBuilder.class.getName()}));
    }

    static OperationMetrics create(String description, Function<Meter, OperationListener> factory, BiConsumer<String, DoubleHistogramBuilder> warningEmitter) {
        return meter -> {
            DoubleHistogramBuilder histogramBuilder = meter.histogramBuilder("compatibility-test");
            if (!(histogramBuilder instanceof ExtendedDoubleHistogramBuilder) && !histogramBuilder.getClass().getName().contains("NoopDoubleHistogram")) {
                warningEmitter.accept(description, histogramBuilder);
                return NOOP_OPERATION_LISTENER;
            }
            return (OperationListener)factory.apply(meter);
        };
    }

    private OperationMetricsUtil() {
    }
}

