/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.directallocation;

import datadog.trace.bootstrap.instrumentation.jfr.ContextualEvent;
import jdk.jfr.Category;
import jdk.jfr.DataAmount;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;

@Name(value="datadog.DirectAllocationSample")
@Label(value="Direct Allocation")
@Description(value="Datadog event corresponding to a direct allocation.")
@Category(value={"Datadog"})
public class DirectAllocationSampleEvent
extends Event
implements ContextualEvent {
    @Label(value="Bytes Allocated")
    @DataAmount
    private final long allocated;
    @Label(value="Allocation Source")
    private final String source;
    @Label(value="Allocating Class")
    private final String allocatingClass;
    @Label(value="Local Root Span Id")
    private long localRootSpanId;
    @Label(value="Span Id")
    private long spanId;

    public DirectAllocationSampleEvent(String allocatingClass, String source, long allocated) {
        this.allocatingClass = allocatingClass;
        this.allocated = allocated;
        this.source = source;
        this.captureContext();
    }

    @Override
    public void setContext(long localRootSpanId, long spanId) {
        this.localRootSpanId = localRootSpanId;
        this.spanId = spanId;
    }
}

