/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger.util;

import datadog.trace.api.Config;
import datadog.trace.util.ClassNameTrie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class Redaction {
    public static final String REDACTED_VALUE = new String("redacted".toCharArray());
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final List<String> PREDEFINED_KEYWORDS = Arrays.asList("2fa", "accesstoken", "aiohttpsession", "apikey", "appkey", "apisecret", "apisignature", "applicationkey", "auth", "authorization", "authtoken", "ccnumber", "certificatepin", "cipher", "clientid", "clientsecret", "connectionstring", "connectsid", "cookie", "credentials", "creditcard", "csrf", "csrftoken", "cvv", "databaseurl", "dburl", "encryptionkey", "encryptionkeyid", "geolocation", "gpgkey", "ipaddress", "jti", "jwt", "licensekey", "masterkey", "mysqlpwd", "nonce", "oauth", "oauthtoken", "otp", "passhash", "passwd", "password", "passwordb", "pemfile", "pgpkey", "phpsessid", "pin", "pincode", "pkcs8", "privatekey", "publickey", "pwd", "recaptchakey", "refreshtoken", "routingnumber", "salt", "secret", "secretkey", "secrettoken", "securityanswer", "securitycode", "securityquestion", "serviceaccountcredentials", "session", "sessionid", "sessionkey", "setcookie", "signature", "signaturekey", "sshkey", "ssn", "symfony", "token", "transactionid", "twiliotoken", "usersession", "voterid", "xapikey", "xauthtoken", "xcsrftoken", "xforwardedfor", "xrealip", "xsrf", "xsrftoken");
    private static final Set<String> KEYWORDS = ConcurrentHashMap.newKeySet();
    private static ClassNameTrie typeTrie = ClassNameTrie.Builder.EMPTY_TRIE;
    private static List<String> redactedClasses;
    private static List<String> redactedPackages;

    static void initKeywords() {
        KEYWORDS.addAll(PREDEFINED_KEYWORDS);
        for (String keyword : Config.get().getDynamicInstrumentationRedactionExcludedIdentifiers()) {
            KEYWORDS.remove(Redaction.normalize(keyword));
        }
    }

    public static void addUserDefinedKeywords(Config config) {
        String[] identifiers;
        String redactedIdentifiers = config.getDynamicInstrumentationRedactedIdentifiers();
        if (redactedIdentifiers == null) {
            return;
        }
        for (String identifier : identifiers = COMMA_PATTERN.split(redactedIdentifiers)) {
            KEYWORDS.add(Redaction.normalize(identifier));
        }
    }

    public static void addUserDefinedTypes(Config config) {
        String[] types;
        String redactedTypes = config.getDynamicInstrumentationRedactedTypes();
        if (redactedTypes == null) {
            return;
        }
        ArrayList<String> packages = null;
        ArrayList<String> classes = null;
        ClassNameTrie.Builder builder = new ClassNameTrie.Builder();
        for (String type : types = COMMA_PATTERN.split(redactedTypes)) {
            builder.put(type, 1);
            if (type.endsWith("*")) {
                if (packages == null) {
                    packages = new ArrayList<String>();
                }
                type = type.endsWith(".*") ? type.substring(0, type.length() - 2) : type.substring(0, type.length() - 1);
                packages.add(type);
                continue;
            }
            if (classes == null) {
                classes = new ArrayList<String>();
            }
            classes.add(type);
        }
        typeTrie = builder.buildTrie();
        redactedPackages = packages;
        redactedClasses = classes;
    }

    public static boolean isRedactedKeyword(String name) {
        if (name == null) {
            return false;
        }
        name = Redaction.normalize(name);
        return KEYWORDS.contains(name);
    }

    public static boolean isRedactedType(String className) {
        if (className == null) {
            return false;
        }
        return typeTrie.apply(className) > 0;
    }

    public static List<String> getRedactedPackages() {
        return redactedPackages != null ? redactedPackages : Collections.emptyList();
    }

    public static List<String> getRedactedClasses() {
        return redactedClasses != null ? redactedClasses : Collections.emptyList();
    }

    public static void clearUserDefinedTypes() {
        typeTrie = ClassNameTrie.Builder.EMPTY_TRIE;
    }

    public static void resetUserDefinedKeywords() {
        KEYWORDS.clear();
        KEYWORDS.addAll(PREDEFINED_KEYWORDS);
    }

    private static String normalize(String name) {
        StringBuilder sb = null;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean isUpper = Character.isUpperCase(c);
            boolean isRemovable = Redaction.isRemovableChar(c);
            if (!isUpper && !isRemovable && sb == null) continue;
            if (sb == null) {
                sb = new StringBuilder(name.substring(0, i));
            }
            if (isUpper) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (isRemovable) continue;
            sb.append(c);
        }
        return sb != null ? sb.toString() : name;
    }

    private static boolean isRemovableChar(char c) {
        return c == '_' || c == '-' || c == '$' || c == '@';
    }

    static {
        Redaction.initKeywords();
    }
}

