/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider.stableconfig;

import datadog.trace.bootstrap.config.provider.stableconfig.Rule;
import datadog.trace.bootstrap.config.provider.stableconfig.StableConfigMappingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class StableConfig {
    private final String configId;
    private final Map<String, Object> apmConfigurationDefault;
    private final List<Rule> apmConfigurationRules;

    public StableConfig(Object yaml) {
        Map map = (Map)yaml;
        this.configId = map.get("config_id") == null ? null : String.valueOf(map.get("config_id"));
        this.apmConfigurationDefault = Collections.unmodifiableMap(map.getOrDefault("apm_configuration_default", Collections.emptyMap()));
        this.apmConfigurationRules = this.parseRules(map);
    }

    private StableConfig(String configId, Map<String, Object> apmConfigurationDefault) {
        this.configId = configId;
        this.apmConfigurationDefault = apmConfigurationDefault;
        this.apmConfigurationRules = new ArrayList<Rule>();
    }

    public String getConfigId() {
        return this.configId;
    }

    public Map<String, Object> getApmConfigurationDefault() {
        return this.apmConfigurationDefault;
    }

    public List<Rule> getApmConfigurationRules() {
        return this.apmConfigurationRules;
    }

    private List<Rule> parseRules(Map<?, ?> map) {
        Object rulesObj = map.get("apm_configuration_rules");
        if (rulesObj instanceof List) {
            List rulesList = (List)rulesObj;
            ArrayList<Rule> rules = new ArrayList<Rule>();
            for (Object ruleObj : rulesList) {
                if (ruleObj instanceof Map) {
                    rules.add(Rule.from((Map)ruleObj));
                    continue;
                }
                StableConfigMappingException.throwStableConfigMappingException("Rule must be a map, but got: " + ruleObj.getClass().getSimpleName() + ": ", ruleObj);
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(rules);
        }
        return Collections.emptyList();
    }
}

