/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.blocking;

import datadog.appsec.api.blocking.BlockingContentType;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockingActionHelper {
    private static final Logger log = LoggerFactory.getLogger(BlockingActionHelper.class);
    private static final int DEFAULT_HTTP_CODE = 403;
    private static final int MAX_ALLOWED_TEMPLATE_SIZE = 512000;
    private static volatile byte[] TEMPLATE_HTML;
    private static volatile byte[] TEMPLATE_JSON;
    public static final String CONTENT_TYPE_HTML = "text/html;charset=utf-8";
    public static final String CONTENT_TYPE_JSON = "application/json";
    private static final Pattern MEDIA_TYPE_PATTERN;
    private static final Pattern QUALITY_PATTERN;

    public static int getHttpCode(int actionHttpCode) {
        if (actionHttpCode < 200 || actionHttpCode > 599) {
            return 403;
        }
        return actionHttpCode;
    }

    public static TemplateType determineTemplateType(BlockingContentType blockingContentType, String acceptHeader) {
        if (blockingContentType == BlockingContentType.HTML) {
            return TemplateType.HTML;
        }
        if (blockingContentType == BlockingContentType.JSON) {
            return TemplateType.JSON;
        }
        if (blockingContentType == BlockingContentType.NONE) {
            throw new IllegalArgumentException("Does not accept BlockingContentType.NONE");
        }
        float jsonPref = 0.0f;
        Specificity curJsonSpecificity = Specificity.UNSPECIFIED;
        float htmlPref = 0.0f;
        Specificity curHtmlSpecificity = Specificity.UNSPECIFIED;
        if (acceptHeader == null) {
            jsonPref = 1.0f;
        } else {
            String mediaType;
            int[] pos = new int[]{0};
            float[] quality = new float[]{0.0f};
            while ((mediaType = BlockingActionHelper.nextMediaRange(acceptHeader, pos, quality)) != null) {
                if (mediaType.equals("*/*")) {
                    if (Specificity.ASTERISK.isMoreSpecificThan(curJsonSpecificity)) {
                        jsonPref = quality[0];
                        curJsonSpecificity = Specificity.ASTERISK;
                    }
                    if (!Specificity.ASTERISK.isMoreSpecificThan(curHtmlSpecificity)) continue;
                    htmlPref = quality[0];
                    curHtmlSpecificity = Specificity.ASTERISK;
                    continue;
                }
                if (mediaType.equals("text/*")) {
                    if (!Specificity.PARTIAL.isMoreSpecificThan(curHtmlSpecificity)) continue;
                    htmlPref = quality[0];
                    curHtmlSpecificity = Specificity.PARTIAL;
                    continue;
                }
                if (mediaType.equals("text/html")) {
                    htmlPref = quality[0];
                    curHtmlSpecificity = Specificity.FULL;
                    continue;
                }
                if (mediaType.equals("application/*")) {
                    if (!Specificity.PARTIAL.isMoreSpecificThan(curJsonSpecificity)) continue;
                    jsonPref = quality[0];
                    curJsonSpecificity = Specificity.PARTIAL;
                    continue;
                }
                if (!mediaType.equals(CONTENT_TYPE_JSON)) continue;
                jsonPref = quality[0];
                curJsonSpecificity = Specificity.FULL;
            }
        }
        if (htmlPref > jsonPref) {
            return TemplateType.HTML;
        }
        return TemplateType.JSON;
    }

    public static byte[] getTemplate(TemplateType type) {
        if (type == TemplateType.JSON) {
            return TEMPLATE_JSON;
        }
        if (type == TemplateType.HTML) {
            return TEMPLATE_HTML;
        }
        return null;
    }

    public static String getContentType(TemplateType type) {
        if (type == TemplateType.JSON) {
            return CONTENT_TYPE_JSON;
        }
        if (type == TemplateType.HTML) {
            return CONTENT_TYPE_HTML;
        }
        return null;
    }

    private static String nextMediaRange(String s, int[] pos, float[] quality) {
        int initPos = pos[0];
        if (initPos >= s.length()) {
            return null;
        }
        int endCommaSep = s.indexOf(44, initPos);
        if (endCommaSep == -1) {
            endCommaSep = s.length();
        }
        pos[0] = endCommaSep + 1;
        String commaSepToken = s.substring(initPos, endCommaSep);
        Matcher mediaRangeMatcher = MEDIA_TYPE_PATTERN.matcher(commaSepToken);
        if (!mediaRangeMatcher.find()) {
            return null;
        }
        Matcher qualityMatcher = QUALITY_PATTERN.matcher(commaSepToken);
        quality[0] = qualityMatcher.find() ? Float.parseFloat(qualityMatcher.group(1)) : 1.0f;
        return mediaRangeMatcher.group(1);
    }

    public static void reset(Config config) {
        String appSecHttpBlockedTemplateJson;
        TEMPLATE_HTML = null;
        TEMPLATE_JSON = null;
        String appSecHttpBlockedTemplateHtml = config.getAppSecHttpBlockedTemplateHtml();
        if (appSecHttpBlockedTemplateHtml != null) {
            File f = new File(appSecHttpBlockedTemplateHtml);
            if (!f.isFile()) {
                log.warn("File referenced in config option {} does not exist: {}", (Object)"appsec.http.blocked.template.html", (Object)f);
            } else {
                TEMPLATE_HTML = BlockingActionHelper.readIntoByteArray(f);
            }
        }
        if (TEMPLATE_HTML == null) {
            TEMPLATE_HTML = BlockingActionHelper.readDefaultTemplate("html");
        }
        if ((appSecHttpBlockedTemplateJson = config.getAppSecHttpBlockedTemplateJson()) != null) {
            File f = new File(appSecHttpBlockedTemplateJson);
            if (!f.isFile()) {
                log.warn("File referenced in config option {} does not exist: {}", (Object)"appsec.http.blocked.template.json", (Object)f);
            } else {
                TEMPLATE_JSON = BlockingActionHelper.readIntoByteArray(f);
            }
        }
        if (TEMPLATE_JSON == null) {
            TEMPLATE_JSON = BlockingActionHelper.readDefaultTemplate("json");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readDefaultTemplate(String ext) {
        try (InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream("datadog/trace/bootstrap/blocking/template." + ext);){
            int read;
            if (is == null) {
                log.error("Could not open default {} template", (Object)ext);
                byte[] byArray2 = new byte[]{101, 114, 114, 111, 114};
                return byArray2;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] b = new byte[8192];
            while ((read = is.read(b)) != -1) {
                baos.write(b, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error("Could not read default {} template", (Object)ext, (Object)e);
            return new byte[]{101, 114, 114, 111, 114};
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readIntoByteArray(File f) {
        long fileSize = f.length();
        if (fileSize > 512000L) {
            log.warn("Template file {} cannot be larger than {} bytes, got file {} bytes long", f, 512000, fileSize);
            return null;
        }
        byte[] res = new byte[(int)fileSize];
        try (FileInputStream fis = new FileInputStream(f);){
            int read = fis.read(res);
            if ((long)read == fileSize) {
                if (fis.read() == -1) return res;
            }
            log.warn("Template file {} changed before it could be fully read", (Object)f);
            byte[] byArray = null;
            return byArray;
        }
        catch (FileNotFoundException e) {
            log.warn("Template file {} could not be opened", (Object)f);
            return null;
        }
        catch (IOException e) {
            log.warn("Error reading template file {}", (Object)f, (Object)e);
            return null;
        }
    }

    static {
        BlockingActionHelper.reset(Config.get());
        MEDIA_TYPE_PATTERN = Pattern.compile("(?x)^[\\ \\t]* ( [!\\#$%&'*+\\-.^_`|~\\da-zA-Z]+/[!\\#$%&'*+\\-.^_`|~\\da-zA-Z]+ )");
        QUALITY_PATTERN = Pattern.compile("(?x);[\\ \\t]* q=( (?:0(?:\\.\\d{0,3})?) | (?:1(?:\\.0{0,3})?) )  (?:$|,|;|[\\ \\t])");
    }

    static enum Specificity {
        UNSPECIFIED,
        ASTERISK,
        PARTIAL,
        FULL;


        public boolean isMoreSpecificThan(Specificity other) {
            return this.ordinal() > other.ordinal();
        }
    }

    public static enum TemplateType {
        JSON,
        HTML;

    }
}

