/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.sampling;

import datadog.trace.api.sampling.AdaptiveSampler;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class PerRecordingRateLimiter {
    private final AdaptiveSampler sampler;

    public PerRecordingRateLimiter(Duration windowDuration, int limit, Duration recordingLength) {
        this(windowDuration, limit, recordingLength, 16);
    }

    public PerRecordingRateLimiter(Duration windowDuration, int limit, Duration recordingLength, int budgetLookback) {
        int lookback = PerRecordingRateLimiter.samplingWindowsPerRecording(recordingLength.getSeconds(), windowDuration);
        int samplesPerWindow = limit / PerRecordingRateLimiter.samplingWindowsPerRecording(recordingLength.getSeconds(), windowDuration);
        this.sampler = new AdaptiveSampler(windowDuration, samplesPerWindow, lookback, budgetLookback, true);
    }

    public boolean permit() {
        return this.sampler.sample();
    }

    public static int samplingWindowsPerRecording(long uploadPeriodSeconds, Duration samplingWindow) {
        return (int)Math.min(Duration.of(uploadPeriodSeconds, ChronoUnit.SECONDS).toMillis() / samplingWindow.toMillis(), Integer.MAX_VALUE);
    }
}

