/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.normalize;

import datadog.trace.api.Config;
import datadog.trace.api.normalize.HttpPathNormalizer;

public final class SimpleHttpPathNormalizer
extends HttpPathNormalizer {
    SimpleHttpPathNormalizer() {
    }

    @Override
    public String normalize(String path, boolean encoded) {
        if (null == path || path.isEmpty()) {
            return "/";
        }
        boolean preserveSpaces = !encoded && Config.get().isHttpServerDecodedResourcePreserveSpaces();
        StringBuilder sb = null;
        int inEncoding = 0;
        int i = 0;
        while (i < path.length()) {
            int nextSlash = path.indexOf(47, i);
            if (nextSlash != i) {
                int endOfSegment = nextSlash == -1 ? path.length() : nextSlash;
                int segmentLength = endOfSegment - i;
                if (segmentLength <= 3 && segmentLength > 1 && (path.charAt(i) | 0x20) == 118) {
                    boolean numeric = true;
                    for (int j = i + 1; j < endOfSegment; ++j) {
                        numeric &= SimpleHttpPathNormalizer.isDigit(path.charAt(j));
                    }
                    if (numeric) {
                        if (sb != null) {
                            sb.append(path, i, endOfSegment);
                        }
                    } else {
                        sb = SimpleHttpPathNormalizer.ensureStringBuilder(sb, path, i);
                        sb.append('?');
                    }
                } else {
                    int snapshot = sb != null ? sb.length() : i;
                    boolean numeric = false;
                    for (int j = i; j < endOfSegment && !numeric; ++j) {
                        char c = path.charAt(j);
                        if (encoded && c == '%') {
                            inEncoding = 3;
                        }
                        boolean bl = numeric = --inEncoding < 0 && SimpleHttpPathNormalizer.isDigit(c);
                        if (numeric) continue;
                        if (Character.isWhitespace(c)) {
                            sb = SimpleHttpPathNormalizer.ensureStringBuilder(sb, path, j);
                            if (!preserveSpaces || sb.length() <= 0) continue;
                            sb.append(c);
                            continue;
                        }
                        if (sb == null) continue;
                        sb.append(c);
                    }
                    if (numeric) {
                        sb = SimpleHttpPathNormalizer.ensureStringBuilder(sb, path, snapshot);
                        sb.setLength(snapshot);
                        sb.append('?');
                    }
                }
                i = endOfSegment + 1;
            } else {
                ++i;
            }
            if (nextSlash == -1 || sb == null) continue;
            sb.append('/');
        }
        return sb == null ? path : (sb.length() == 0 ? "/" : sb.toString());
    }

    private static boolean isDigit(char c) {
        return c <= '9' && c >= '0';
    }

    private static StringBuilder ensureStringBuilder(StringBuilder sb, String path, int position) {
        if (sb == null) {
            sb = new StringBuilder();
            sb.append(path, 0, position);
        }
        return sb;
    }
}

