/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.metrics;

import datadog.trace.api.metrics.CoreCounter;
import datadog.trace.api.metrics.SpanMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

public class SpanMetricsImpl
implements SpanMetrics {
    private final String instrumentationName;
    private final AtomicLong spanCreatedCounter;
    private final AtomicLong spanFinishedCounter;
    private final Collection<CoreCounter> coreCounters;

    public SpanMetricsImpl(String instrumentationName) {
        this.instrumentationName = instrumentationName;
        this.spanCreatedCounter = new AtomicLong(0L);
        this.spanFinishedCounter = new AtomicLong(0L);
        ArrayList<SpanCounter> coreCounters = new ArrayList<SpanCounter>(2);
        coreCounters.add(new SpanCounter("spans_created", this.spanCreatedCounter));
        coreCounters.add(new SpanCounter("spans_finished", this.spanFinishedCounter));
        this.coreCounters = Collections.unmodifiableList(coreCounters);
    }

    @Override
    public void onSpanCreated() {
        this.spanCreatedCounter.incrementAndGet();
    }

    @Override
    public void onSpanFinished() {
        this.spanFinishedCounter.incrementAndGet();
    }

    public String getInstrumentationName() {
        return this.instrumentationName;
    }

    public Collection<CoreCounter> getCounters() {
        return this.coreCounters;
    }

    private static class SpanCounter
    implements CoreCounter {
        private final String name;
        private final AtomicLong counter;
        private long previousCount;

        private SpanCounter(String name, AtomicLong counter) {
            this.name = name;
            this.counter = counter;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getValue() {
            return this.counter.get();
        }

        @Override
        public long getValueAndReset() {
            long count = this.counter.get();
            long delta = count - this.previousCount;
            this.previousCount = count;
            return delta;
        }
    }
}

