/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.Config;
import datadog.trace.api.env.CapturedEnvironment;
import datadog.trace.api.remoteconfig.ServiceNameCollector;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassloaderConfigurationOverrides {
    public static final String DATADOG_TAGS_PREFIX = "datadog/tags/";
    public static final String DATADOG_TAGS_JNDI_PREFIX = "java:comp/env/datadog/tags/";
    static boolean CAN_SPLIT_SERVICE_NAME_BY_DEPLOYMENT = Config.get().isJeeSplitByDeployment() && !Config.get().isServiceNameSetByUser();
    private static final Function<ClassLoader, ContextualInfo> EMPTY_CONTEXTUAL_INFO_ADDER = ignored -> new ContextualInfo(null);
    private final WeakHashMap<ClassLoader, ContextualInfo> weakCache = new WeakHashMap();
    private final String inferredServiceName = CapturedEnvironment.get().getProperties().get("service.name");
    private static volatile boolean atLeastOneEntry;
    private static final Lock lock;

    private ClassloaderConfigurationOverrides() {
    }

    public static void addContextualInfo(ClassLoader classLoader, ContextualInfo contextualInfo) {
        try {
            lock.lock();
            Lazy.INSTANCE.weakCache.put(classLoader, contextualInfo);
            atLeastOneEntry = true;
        }
        finally {
            lock.unlock();
        }
    }

    public static ContextualInfo maybeCreateContextualInfo(ClassLoader classLoader) {
        try {
            lock.lock();
            ContextualInfo ret = Lazy.INSTANCE.weakCache.computeIfAbsent(classLoader, EMPTY_CONTEXTUAL_INFO_ADDER);
            atLeastOneEntry = true;
            ContextualInfo contextualInfo = ret;
            return contextualInfo;
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    public static ContextualInfo withPinnedServiceName(ClassLoader classLoader, String serviceName) {
        if (!CAN_SPLIT_SERVICE_NAME_BY_DEPLOYMENT) {
            return null;
        }
        ContextualInfo contextualInfo = new ContextualInfo(serviceName);
        ClassloaderConfigurationOverrides.addContextualInfo(classLoader, contextualInfo);
        return contextualInfo;
    }

    @Nullable
    public static ContextualInfo maybeGetContextualInfo(ClassLoader classLoader) {
        if (atLeastOneEntry) {
            return Lazy.INSTANCE.weakCache.get(classLoader);
        }
        return null;
    }

    @Nullable
    public static ContextualInfo maybeGetContextualInfo() {
        if (atLeastOneEntry) {
            return ClassloaderConfigurationOverrides.maybeGetContextualInfo(Thread.currentThread().getContextClassLoader());
        }
        return null;
    }

    public static void maybeEnrichSpan(@Nonnull AgentSpan span) {
        if (atLeastOneEntry) {
            ClassloaderConfigurationOverrides.maybeEnrichSpan(span, Thread.currentThread().getContextClassLoader());
        }
    }

    public static void maybeEnrichSpan(@Nonnull AgentSpan span, @Nonnull ClassLoader classLoader) {
        String currentServiceName;
        ContextualInfo contextualInfo = ClassloaderConfigurationOverrides.maybeGetContextualInfo(classLoader);
        if (contextualInfo == null) {
            return;
        }
        String serviceName = contextualInfo.getServiceName();
        if (CAN_SPLIT_SERVICE_NAME_BY_DEPLOYMENT && serviceName != null && !serviceName.isEmpty() && ((currentServiceName = span.getServiceName()) == null || currentServiceName.equals(Lazy.INSTANCE.inferredServiceName))) {
            span.setServiceName(serviceName);
            ServiceNameCollector.get().addService(serviceName);
        }
        contextualInfo.getTags().forEach(span::setTag);
    }

    static {
        lock = new ReentrantLock();
    }

    public static class ContextualInfo {
        private final String serviceName;
        private final Map<String, Object> tags = new HashMap<String, Object>();

        public ContextualInfo(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void addTag(String name, Object value) {
            this.tags.put(name, value);
        }

        public Map<String, Object> getTags() {
            return Collections.unmodifiableMap(this.tags);
        }
    }

    static class Lazy {
        static final ClassloaderConfigurationOverrides INSTANCE = new ClassloaderConfigurationOverrides();

        Lazy() {
        }
    }
}

