/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;

public class AgentPreCheck {
    public static final int MIN_JAVA_VERSION = 8;

    public static void premain(String agentArgs, Instrumentation inst) {
        AgentPreCheck.agentmain(agentArgs, inst);
    }

    @SuppressForbidden
    public static void agentmain(String agentArgs, Instrumentation inst) {
        try {
            if (AgentPreCheck.compatible()) {
                AgentPreCheck.continueBootstrap(agentArgs, inst);
            }
        }
        catch (Throwable e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }

    private static void reportIncompatibleJava(String javaVersion, String javaHome, String agentVersion, PrintStream output) {
        output.println("Warning: " + (agentVersion == null ? "This version" : "Version " + agentVersion) + " of dd-java-agent is not compatible with Java " + javaVersion + " found at '" + javaHome + "' and is effectively disabled.");
        output.println("Please upgrade your Java version to 8+");
    }

    static void sendTelemetry(String forwarderPath, String javaVersion, String agentVersion) {
        String payload = "{\"metadata\":{\"runtime_name\":\"jvm\",\"language_name\":\"jvm\",\"runtime_version\":\"" + javaVersion + "\",\"language_version\":\"" + javaVersion + "\",\"tracer_version\":\"" + agentVersion + "\",\"result\":\"abort\",\"result_class\":\"unknown\",\"result_reason\":\"incompatible_runtime\"},\"points\":[{\"name\":\"library_entrypoint.abort\",\"tags\":[\"reason:incompatible_runtime\"]}]}";
        ForwarderJsonSenderThread t = new ForwarderJsonSenderThread(forwarderPath, payload);
        t.setDaemon(true);
        t.start();
    }

    private static String tryGetProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    @SuppressForbidden
    private static boolean compatible() {
        String javaVersion = AgentPreCheck.tryGetProperty("java.version");
        String javaHome = AgentPreCheck.tryGetProperty("java.home");
        return AgentPreCheck.compatible(javaVersion, javaHome, System.err);
    }

    static boolean compatible(String javaVersion, String javaHome, PrintStream output) {
        int majorJavaVersion = AgentPreCheck.parseJavaMajorVersion(javaVersion);
        if (majorJavaVersion >= 8) {
            return true;
        }
        String agentVersion = AgentPreCheck.getAgentVersion();
        AgentPreCheck.reportIncompatibleJava(javaVersion, javaHome, agentVersion, output);
        String forwarderPath = System.getenv("DD_TELEMETRY_FORWARDER_PATH");
        if (forwarderPath != null) {
            AgentPreCheck.sendTelemetry(forwarderPath, javaVersion, agentVersion);
        }
        return false;
    }

    static int parseJavaMajorVersion(String javaVersion) {
        char c;
        int major = 0;
        if (javaVersion == null || javaVersion.isEmpty()) {
            return major;
        }
        int start = 0;
        if (javaVersion.charAt(0) == '1' && javaVersion.length() >= 3 && javaVersion.charAt(1) == '.' && Character.isDigit(javaVersion.charAt(2))) {
            start = 2;
        }
        for (int i = start; i < javaVersion.length() && Character.isDigit(c = javaVersion.charAt(i)); ++i) {
            major *= 10;
            major += Character.digit(c, 10);
        }
        return major;
    }

    private static String getAgentVersion() {
        try {
            InputStream is = AgentPreCheck.class.getResourceAsStream("/dd-java-agent.version");
            if (is == null) {
                return null;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            int c = reader.read();
            while (c != -1) {
                sb.append((char)c);
                c = reader.read();
            }
            reader.close();
            return sb.toString().trim();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @SuppressForbidden
    private static void continueBootstrap(String agentArgs, Instrumentation inst) throws Exception {
        Class<?> clazz = Class.forName("datadog.trace.bootstrap.AgentBootstrap");
        Method agentMain = clazz.getMethod("agentmain", String.class, Instrumentation.class);
        agentMain.invoke(null, agentArgs, inst);
    }

    public static final class ForwarderJsonSenderThread
    extends Thread {
        private final String forwarderPath;
        private final String payload;

        public ForwarderJsonSenderThread(String forwarderPath, String payload) {
            super("dd-forwarder-json-sender");
            this.setDaemon(true);
            this.forwarderPath = forwarderPath;
            this.payload = payload;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressForbidden
        public void run() {
            ProcessBuilder builder = new ProcessBuilder(this.forwarderPath, "library_entrypoint");
            try {
                Process process = builder.start();
                OutputStream out = null;
                try {
                    out = process.getOutputStream();
                    out.write(this.payload.getBytes());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (Throwable e) {
                System.err.println("Failed to send telemetry: " + e.getMessage());
            }
        }
    }
}

