/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EventsCompute;
import com.datadog.api.client.v2.model.EventsDataSource;
import com.datadog.api.client.v2.model.EventsGroupBy;
import com.datadog.api.client.v2.model.EventsSearch;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"compute", "data_source", "group_by", "indexes", "name", "search"})
public class EventsScalarQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private EventsCompute compute;
    public static final String JSON_PROPERTY_DATA_SOURCE = "data_source";
    private EventsDataSource dataSource = EventsDataSource.LOGS;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<EventsGroupBy> groupBy = null;
    public static final String JSON_PROPERTY_INDEXES = "indexes";
    private List<String> indexes = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SEARCH = "search";
    private EventsSearch search;

    public EventsScalarQuery() {
    }

    @JsonCreator
    public EventsScalarQuery(@JsonProperty(required=true, value="compute") EventsCompute compute, @JsonProperty(required=true, value="data_source") EventsDataSource dataSource) {
        this.compute = compute;
        this.unparsed |= compute.unparsed;
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
    }

    public EventsScalarQuery compute(EventsCompute compute) {
        this.compute = compute;
        this.unparsed |= compute.unparsed;
        return this;
    }

    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventsCompute getCompute() {
        return this.compute;
    }

    public void setCompute(EventsCompute compute) {
        this.compute = compute;
    }

    public EventsScalarQuery dataSource(EventsDataSource dataSource) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        return this;
    }

    @JsonProperty(value="data_source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventsDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(EventsDataSource dataSource) {
        if (!dataSource.isValid()) {
            this.unparsed = true;
        }
        this.dataSource = dataSource;
    }

    public EventsScalarQuery groupBy(List<EventsGroupBy> groupBy) {
        this.groupBy = groupBy;
        for (EventsGroupBy item : groupBy) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public EventsScalarQuery addGroupByItem(EventsGroupBy groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<EventsGroupBy>();
        }
        this.groupBy.add(groupByItem);
        this.unparsed |= groupByItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EventsGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<EventsGroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public EventsScalarQuery indexes(List<String> indexes) {
        this.indexes = indexes;
        return this;
    }

    public EventsScalarQuery addIndexesItem(String indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<String>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public EventsScalarQuery name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EventsScalarQuery search(EventsSearch search) {
        this.search = search;
        this.unparsed |= search.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="search")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventsSearch getSearch() {
        return this.search;
    }

    public void setSearch(EventsSearch search) {
        this.search = search;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsScalarQuery eventsScalarQuery = (EventsScalarQuery)o;
        return Objects.equals(this.compute, eventsScalarQuery.compute) && Objects.equals(this.dataSource, eventsScalarQuery.dataSource) && Objects.equals(this.groupBy, eventsScalarQuery.groupBy) && Objects.equals(this.indexes, eventsScalarQuery.indexes) && Objects.equals(this.name, eventsScalarQuery.name) && Objects.equals(this.search, eventsScalarQuery.search);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.dataSource, this.groupBy, this.indexes, this.name, this.search);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsScalarQuery {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    search: ").append(this.toIndentedString(this.search)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

