/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CIAppAggregationFunction;
import com.datadog.api.client.v2.model.CIAppComputeType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregation", "interval", "metric", "type"})
public class CIAppCompute {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private CIAppAggregationFunction aggregation;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private String interval;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_TYPE = "type";
    private CIAppComputeType type = CIAppComputeType.TOTAL;

    public CIAppCompute() {
    }

    @JsonCreator
    public CIAppCompute(@JsonProperty(required=true, value="aggregation") CIAppAggregationFunction aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
    }

    public CIAppCompute aggregation(CIAppAggregationFunction aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CIAppAggregationFunction getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(CIAppAggregationFunction aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public CIAppCompute interval(String interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public CIAppCompute metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public CIAppCompute type(CIAppComputeType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppComputeType getType() {
        return this.type;
    }

    public void setType(CIAppComputeType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIAppCompute ciAppCompute = (CIAppCompute)o;
        return Objects.equals(this.aggregation, ciAppCompute.aggregation) && Objects.equals(this.interval, ciAppCompute.interval) && Objects.equals(this.metric, ciAppCompute.metric) && Objects.equals(this.type, ciAppCompute.type);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.interval, this.metric, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CIAppCompute {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

