/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.TreeMapColorBy;
import com.datadog.api.client.v1.model.TreeMapGroupBy;
import com.datadog.api.client.v1.model.TreeMapSizeBy;
import com.datadog.api.client.v1.model.TreeMapWidgetDefinitionType;
import com.datadog.api.client.v1.model.TreeMapWidgetRequest;
import com.datadog.api.client.v1.model.WidgetCustomLink;
import com.datadog.api.client.v1.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"color_by", "custom_links", "group_by", "requests", "size_by", "time", "title", "type"})
public class TreeMapWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COLOR_BY = "color_by";
    private TreeMapColorBy colorBy = TreeMapColorBy.USER;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private TreeMapGroupBy groupBy;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<TreeMapWidgetRequest> requests = new ArrayList<TreeMapWidgetRequest>();
    public static final String JSON_PROPERTY_SIZE_BY = "size_by";
    private TreeMapSizeBy sizeBy;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TreeMapWidgetDefinitionType type = TreeMapWidgetDefinitionType.TREEMAP;

    public TreeMapWidgetDefinition() {
    }

    @JsonCreator
    public TreeMapWidgetDefinition(@JsonProperty(required=true, value="requests") List<TreeMapWidgetRequest> requests, @JsonProperty(required=true, value="type") TreeMapWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public TreeMapWidgetDefinition colorBy(TreeMapColorBy colorBy) {
        this.colorBy = colorBy;
        this.unparsed |= !colorBy.isValid();
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="color_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TreeMapColorBy getColorBy() {
        return this.colorBy;
    }

    @Deprecated
    public void setColorBy(TreeMapColorBy colorBy) {
        if (!colorBy.isValid()) {
            this.unparsed = true;
        }
        this.colorBy = colorBy;
    }

    public TreeMapWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        for (WidgetCustomLink item : customLinks) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TreeMapWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        this.unparsed |= customLinksItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public TreeMapWidgetDefinition groupBy(TreeMapGroupBy groupBy) {
        this.groupBy = groupBy;
        this.unparsed |= !groupBy.isValid();
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TreeMapGroupBy getGroupBy() {
        return this.groupBy;
    }

    @Deprecated
    public void setGroupBy(TreeMapGroupBy groupBy) {
        if (!groupBy.isValid()) {
            this.unparsed = true;
        }
        this.groupBy = groupBy;
    }

    public TreeMapWidgetDefinition requests(List<TreeMapWidgetRequest> requests) {
        this.requests = requests;
        for (TreeMapWidgetRequest item : requests) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public TreeMapWidgetDefinition addRequestsItem(TreeMapWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        this.unparsed |= requestsItem.unparsed;
        return this;
    }

    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TreeMapWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<TreeMapWidgetRequest> requests) {
        this.requests = requests;
    }

    public TreeMapWidgetDefinition sizeBy(TreeMapSizeBy sizeBy) {
        this.sizeBy = sizeBy;
        this.unparsed |= !sizeBy.isValid();
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="size_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TreeMapSizeBy getSizeBy() {
        return this.sizeBy;
    }

    @Deprecated
    public void setSizeBy(TreeMapSizeBy sizeBy) {
        if (!sizeBy.isValid()) {
            this.unparsed = true;
        }
        this.sizeBy = sizeBy;
    }

    public TreeMapWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public TreeMapWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TreeMapWidgetDefinition type(TreeMapWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TreeMapWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(TreeMapWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeMapWidgetDefinition treeMapWidgetDefinition = (TreeMapWidgetDefinition)o;
        return Objects.equals(this.colorBy, treeMapWidgetDefinition.colorBy) && Objects.equals(this.customLinks, treeMapWidgetDefinition.customLinks) && Objects.equals(this.groupBy, treeMapWidgetDefinition.groupBy) && Objects.equals(this.requests, treeMapWidgetDefinition.requests) && Objects.equals(this.sizeBy, treeMapWidgetDefinition.sizeBy) && Objects.equals(this.time, treeMapWidgetDefinition.time) && Objects.equals(this.title, treeMapWidgetDefinition.title) && Objects.equals(this.type, treeMapWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(this.colorBy, this.customLinks, this.groupBy, this.requests, this.sizeBy, this.time, this.title, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TreeMapWidgetDefinition {\n");
        sb.append("    colorBy: ").append(this.toIndentedString(this.colorBy)).append("\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    sizeBy: ").append(this.toIndentedString(this.sizeBy)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

