/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CIAppCompute;
import com.datadog.api.client.v2.model.CIAppQueryOptions;
import com.datadog.api.client.v2.model.CIAppQueryPageOptions;
import com.datadog.api.client.v2.model.CIAppTestsGroupBy;
import com.datadog.api.client.v2.model.CIAppTestsQueryFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"compute", "filter", "group_by", "options", "page"})
public class CIAppTestsAggregateRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private List<CIAppCompute> compute = null;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private CIAppTestsQueryFilter filter;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<CIAppTestsGroupBy> groupBy = null;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private CIAppQueryOptions options;
    public static final String JSON_PROPERTY_PAGE = "page";
    private CIAppQueryPageOptions page;

    public CIAppTestsAggregateRequest compute(List<CIAppCompute> compute) {
        this.compute = compute;
        for (CIAppCompute item : compute) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public CIAppTestsAggregateRequest addComputeItem(CIAppCompute computeItem) {
        if (this.compute == null) {
            this.compute = new ArrayList<CIAppCompute>();
        }
        this.compute.add(computeItem);
        this.unparsed |= computeItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CIAppCompute> getCompute() {
        return this.compute;
    }

    public void setCompute(List<CIAppCompute> compute) {
        this.compute = compute;
    }

    public CIAppTestsAggregateRequest filter(CIAppTestsQueryFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppTestsQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(CIAppTestsQueryFilter filter) {
        this.filter = filter;
    }

    public CIAppTestsAggregateRequest groupBy(List<CIAppTestsGroupBy> groupBy) {
        this.groupBy = groupBy;
        for (CIAppTestsGroupBy item : groupBy) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public CIAppTestsAggregateRequest addGroupByItem(CIAppTestsGroupBy groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<CIAppTestsGroupBy>();
        }
        this.groupBy.add(groupByItem);
        this.unparsed |= groupByItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CIAppTestsGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<CIAppTestsGroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public CIAppTestsAggregateRequest options(CIAppQueryOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppQueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(CIAppQueryOptions options) {
        this.options = options;
    }

    public CIAppTestsAggregateRequest page(CIAppQueryPageOptions page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppQueryPageOptions getPage() {
        return this.page;
    }

    public void setPage(CIAppQueryPageOptions page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIAppTestsAggregateRequest ciAppTestsAggregateRequest = (CIAppTestsAggregateRequest)o;
        return Objects.equals(this.compute, ciAppTestsAggregateRequest.compute) && Objects.equals(this.filter, ciAppTestsAggregateRequest.filter) && Objects.equals(this.groupBy, ciAppTestsAggregateRequest.groupBy) && Objects.equals(this.options, ciAppTestsAggregateRequest.options) && Objects.equals(this.page, ciAppTestsAggregateRequest.page);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.filter, this.groupBy, this.options, this.page);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CIAppTestsAggregateRequest {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

